/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.digestionvat;

import com.klikli_dev.theurgy.content.recipe.DigestionRecipe;
import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerWithFluidRecipeInput;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DigestionCachedCheck
implements RecipeManager.CachedCheck<ItemHandlerWithFluidRecipeInput, DigestionRecipe> {
    private final RecipeType<DigestionRecipe> type;
    private final RecipeManager.CachedCheck<ItemHandlerWithFluidRecipeInput, DigestionRecipe> internal;
    @Nullable
    private ResourceLocation lastRecipeForFluidStack;
    @Nullable
    private ResourceLocation lastRecipeForItemStack;
    @Nullable
    private ResourceLocation lastRecipeForItemStackCollection;
    private boolean noRecipeForLastItemStackCollectionInput;
    private boolean noRecipeForLastItemStackInput;
    private boolean noRecipeForLastFluidStackInput;
    private boolean noRecipeForLastItemHandlerInput;
    private Collection<ItemStack> lastItemStackCollectionInput;
    private ItemStack lastItemStackInput;
    private FluidStack lastFluidStackInput;

    public DigestionCachedCheck(RecipeType<DigestionRecipe> type) {
        this.type = type;
        this.internal = RecipeManager.createCheck(type);
    }

    public void resetNoRecipeForLastItemHandlerInput() {
        this.noRecipeForLastItemHandlerInput = false;
    }

    private boolean matchesRecipe(RecipeHolder<DigestionRecipe> recipe, Collection<ItemStack> input) {
        NonNullList<Ingredient> ingredients = ((DigestionRecipe)recipe.value()).getIngredients();
        return input.stream().allMatch(stack -> ingredients.stream().anyMatch(ingredient -> ingredient.test(stack)));
    }

    private boolean isSameInput(Collection<ItemStack> input) {
        return Objects.equals(this.lastItemStackCollectionInput, input);
    }

    private boolean isSameInput(ItemStack input) {
        return ItemStack.matches((ItemStack)this.lastItemStackInput, (ItemStack)input);
    }

    private boolean isSameInput(FluidStack input) {
        return FluidStack.matches((FluidStack)this.lastFluidStackInput, (FluidStack)input);
    }

    private Optional<RecipeHolder<DigestionRecipe>> getRecipeFor(Collection<ItemStack> input, Level level, @Nullable ResourceLocation lastRecipe) {
        RecipeHolder recipe;
        RecipeManager recipeManager = level.getRecipeManager();
        if (lastRecipe != null && (recipe = recipeManager.byKeyTyped(this.type, lastRecipe)) != null && this.matchesRecipe((RecipeHolder<DigestionRecipe>)recipe, input)) {
            return Optional.of(recipe);
        }
        return recipeManager.byType(this.type).stream().filter(entry -> this.matchesRecipe((RecipeHolder<DigestionRecipe>)entry, input)).findFirst();
    }

    private Optional<RecipeHolder<DigestionRecipe>> getRecipeFor(ItemStack stack, Level level, @Nullable ResourceLocation lastRecipe) {
        RecipeHolder recipe;
        RecipeManager recipeManager = level.getRecipeManager();
        if (lastRecipe != null && (recipe = recipeManager.byKeyTyped(this.type, lastRecipe)) != null && ((DigestionRecipe)recipe.value()).getIngredients().stream().anyMatch(i -> i.test(stack))) {
            return Optional.of(recipe);
        }
        return recipeManager.byType(this.type).stream().filter(entry -> ((DigestionRecipe)entry.value()).getIngredients().stream().anyMatch(i -> i.test(stack))).findFirst();
    }

    private Optional<RecipeHolder<DigestionRecipe>> getRecipeFor(FluidStack stack, Level level, @Nullable ResourceLocation lastRecipe) {
        RecipeHolder recipe;
        RecipeManager recipeManager = level.getRecipeManager();
        if (lastRecipe != null && (recipe = recipeManager.byKeyTyped(this.type, lastRecipe)) != null && ((DigestionRecipe)recipe.value()).getFluid().ingredient().test(stack)) {
            return Optional.of(recipe);
        }
        return recipeManager.byType(this.type).stream().filter(entry -> ((DigestionRecipe)entry.value()).getFluid().ingredient().test(stack)).findFirst();
    }

    public Optional<RecipeHolder<DigestionRecipe>> getRecipeFor(Collection<ItemStack> input, Level level) {
        if (this.noRecipeForLastItemStackCollectionInput && this.isSameInput(input)) {
            return Optional.empty();
        }
        Optional<RecipeHolder<DigestionRecipe>> optional = this.getRecipeFor(input, level, this.lastRecipeForItemStackCollection);
        if (optional.isPresent()) {
            RecipeHolder<DigestionRecipe> recipeHolder = optional.get();
            this.lastRecipeForItemStackCollection = recipeHolder.id();
            this.noRecipeForLastItemStackCollectionInput = false;
            this.lastItemStackCollectionInput = input;
            return optional;
        }
        this.noRecipeForLastItemStackCollectionInput = true;
        this.lastItemStackCollectionInput = input;
        return Optional.empty();
    }

    public Optional<RecipeHolder<DigestionRecipe>> getRecipeFor(ItemStack stack, Level level) {
        if (this.noRecipeForLastItemStackInput && this.isSameInput(stack)) {
            return Optional.empty();
        }
        Optional<RecipeHolder<DigestionRecipe>> optional = this.getRecipeFor(stack, level, this.lastRecipeForItemStack);
        if (optional.isPresent()) {
            RecipeHolder<DigestionRecipe> recipeHolder = optional.get();
            this.lastRecipeForItemStack = recipeHolder.id();
            this.noRecipeForLastItemStackInput = false;
            this.lastItemStackInput = stack;
            return optional;
        }
        this.noRecipeForLastItemStackInput = true;
        this.lastItemStackInput = stack;
        return Optional.empty();
    }

    public Optional<RecipeHolder<DigestionRecipe>> getRecipeFor(FluidStack stack, Level level) {
        if (this.noRecipeForLastFluidStackInput && this.isSameInput(stack)) {
            return Optional.empty();
        }
        Optional<RecipeHolder<DigestionRecipe>> optional = this.getRecipeFor(stack, level, this.lastRecipeForFluidStack);
        if (optional.isPresent()) {
            RecipeHolder<DigestionRecipe> recipeHolder = optional.get();
            this.lastRecipeForFluidStack = recipeHolder.id();
            this.noRecipeForLastFluidStackInput = false;
            this.lastFluidStackInput = stack;
            return optional;
        }
        this.noRecipeForLastFluidStackInput = true;
        this.lastFluidStackInput = stack;
        return Optional.empty();
    }

    @NotNull
    public Optional<RecipeHolder<DigestionRecipe>> getRecipeFor(@NotNull ItemHandlerWithFluidRecipeInput container, @NotNull Level level) {
        if (this.noRecipeForLastItemHandlerInput) {
            return Optional.empty();
        }
        Optional optional = this.internal.getRecipeFor((RecipeInput)container, level);
        if (optional.isPresent()) {
            this.noRecipeForLastItemHandlerInput = false;
            return optional;
        }
        this.noRecipeForLastItemHandlerInput = true;
        return Optional.empty();
    }
}

