/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.calcinationoven;

import com.klikli_dev.theurgy.content.recipe.CalcinationRecipe;
import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerRecipeInput;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CalcinationCachedCheck
implements RecipeManager.CachedCheck<ItemHandlerRecipeInput, CalcinationRecipe> {
    private final RecipeType<CalcinationRecipe> type;
    private final RecipeManager.CachedCheck<ItemHandlerRecipeInput, CalcinationRecipe> internal;
    @Nullable
    private ResourceLocation lastRecipe;

    public CalcinationCachedCheck(RecipeType<CalcinationRecipe> type) {
        this.type = type;
        this.internal = RecipeManager.createCheck(type);
    }

    private Optional<RecipeHolder<CalcinationRecipe>> getRecipeFor(ItemStack stack, Level level, @Nullable ResourceLocation lastRecipe) {
        RecipeHolder recipe;
        RecipeManager recipeManager = level.getRecipeManager();
        if (lastRecipe != null && (recipe = recipeManager.byKeyTyped(this.type, lastRecipe)) != null && ((CalcinationRecipe)recipe.value()).sizedIngredient().ingredient().test(stack)) {
            return Optional.of(recipe);
        }
        return recipeManager.byType(this.type).stream().filter(entry -> ((CalcinationRecipe)entry.value()).sizedIngredient().ingredient().test(stack)).findFirst();
    }

    public Optional<RecipeHolder<CalcinationRecipe>> getRecipeFor(ItemStack stack, Level level) {
        Optional<RecipeHolder<CalcinationRecipe>> optional = this.getRecipeFor(stack, level, this.lastRecipe);
        if (optional.isPresent()) {
            RecipeHolder<CalcinationRecipe> recipeHolder = optional.get();
            this.lastRecipe = recipeHolder.id();
            return optional;
        }
        return Optional.empty();
    }

    @NotNull
    public Optional<RecipeHolder<CalcinationRecipe>> getRecipeFor(@NotNull ItemHandlerRecipeInput container, @NotNull Level level) {
        Optional recipe = this.internal.getRecipeFor((RecipeInput)container, level);
        if (recipe.isPresent()) {
            this.lastRecipe = ((RecipeHolder)recipe.get()).id();
        }
        return recipe;
    }
}

