/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.entity.baby;

import mekanism.additions.common.registries.AdditionsEntityTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EntityBabyCreeper
extends Creeper {
    public EntityBabyCreeper(EntityType<EntityBabyCreeper> type, Level world) {
        super(type, world);
        this.xpReward = (int)((double)this.xpReward * 2.5);
        AdditionsEntityTypes.setupBabyModifiers((LivingEntity)this);
    }

    public boolean isBaby() {
        return true;
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        return this.getType().getDimensions();
    }

    protected void explodeCreeper() {
        if (!this.level().isClientSide) {
            float f = this.isPowered() ? 1.0f : 0.5f;
            this.dead = true;
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)this.explosionRadius * f, Level.ExplosionInteraction.MOB);
            this.discard();
            this.spawnLingeringCloud();
        }
    }
}

