/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class ShapeUtils {
    private ShapeUtils() {
    }

    public static VoxelShape rotate(VoxelShape down, Direction direction) {
        if (direction == Direction.DOWN) {
            return down;
        }
        return down.toAabbs().stream().map(b -> Shapes.create((AABB)ShapeUtils.rotate(b, direction))).reduce((a, b) -> Shapes.joinUnoptimized((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR)).map(VoxelShape::optimize).orElse(Shapes.empty());
    }

    public static AABB rotate(AABB down, Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> down;
            case Direction.UP -> new AABB(down.minX, 1.0 - down.maxY, down.minZ, down.maxX, 1.0 - down.minY, down.maxZ);
            case Direction.NORTH -> new AABB(down.minX, down.minZ, down.minY, down.maxX, down.maxZ, down.maxY);
            case Direction.SOUTH -> new AABB(down.minX, down.minZ, 1.0 - down.maxY, down.maxX, down.maxZ, 1.0 - down.minY);
            case Direction.WEST -> new AABB(down.minY, down.minX, down.minZ, down.maxY, down.maxX, down.maxZ);
            case Direction.EAST -> new AABB(1.0 - down.maxY, down.minX, down.minZ, 1.0 - down.minY, down.maxX, down.maxZ);
        };
    }
}

