/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.slots;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.ui.slots.FancySlot;
import tv.soaryn.xycraft.core.utils.BitFlagUtils;

public class GhostSlot
extends FancySlot {
    private final int limit;
    private boolean ghostedRender = true;
    public ContainerData strictSource;
    public int strictIndex;

    public GhostSlot(int x, int y, ItemContainer inventory, int slot, int limit) {
        super(x, y, inventory, slot);
        this.limit = limit;
    }

    public GhostSlot ghostRendered(boolean value) {
        this.ghostedRender = value;
        return this;
    }

    @Override
    public boolean mayPlace(@NotNull ItemStack stack) {
        return false;
    }

    @Override
    public boolean mayPickup(@NotNull Player player) {
        return false;
    }

    @Override
    public int getMaxStackSize() {
        return this.limit;
    }

    public boolean isStrict() {
        return this.strictSource != null && BitFlagUtils.getFlag(this.strictSource.get(this.strictIndex), this.getSlotIndex());
    }

    public GhostSlot setStrictContainer(ContainerData menuData, int index) {
        this.strictSource = menuData;
        this.strictIndex = index;
        return this;
    }

    public GhostSlot setStrictInternal(boolean strict) {
        if (this.strictSource != null) {
            this.strictSource.set(this.strictIndex, BitFlagUtils.setAccessFlag(this.strictSource.get(this.strictIndex), strict, this.getSlotIndex()));
        }
        return this;
    }

    public boolean isGhostedRender() {
        return this.ghostedRender;
    }
}

