/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content;

import java.util.HashMap;
import java.util.function.BooleanSupplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.content.fluids.XyFluidType;

public class FluidContent
implements IContent<FluidContent> {
    public final DeferredHolder<FluidType, XyFluidType> Type;
    public final DeferredHolder<Fluid, BaseFlowingFluid.Source> Source;
    public final DeferredHolder<Fluid, BaseFlowingFluid.Flowing> Flowing;
    private String _modelPath;
    protected final HashMap<String, String> _localizations = new HashMap();
    private BooleanSupplier _requirement = () -> true;
    private DeferredHolder<CreativeModeTab, CreativeModeTab> _tab;

    public FluidContent(DeferredHolder<FluidType, XyFluidType> type, DeferredHolder<Fluid, BaseFlowingFluid.Source> source, DeferredHolder<Fluid, BaseFlowingFluid.Flowing> flowing) {
        this.Type = type;
        this.Source = source;
        this.Flowing = flowing;
    }

    @Override
    public ResourceLocation id() {
        return this.Type.getId();
    }

    @Override
    public FluidContent withModelPath(String modelPath) {
        this._modelPath = modelPath;
        return this;
    }

    @Override
    public FluidContent withName(String locale, String localizedName) {
        this._localizations.put(locale, localizedName);
        return this;
    }

    @Override
    public FluidContent requires(BooleanSupplier requirement) {
        this._requirement = requirement;
        return this;
    }

    @Override
    public boolean hasPrerequisites() {
        return this._requirement.getAsBoolean();
    }

    @Override
    public String getLocalizedName(String locale) {
        return this._localizations.get(locale);
    }

    @Override
    public String modelPath() {
        return this._modelPath;
    }

    @Override
    public DeferredHolder<CreativeModeTab, CreativeModeTab> tab() {
        return this._tab;
    }

    @Override
    public FluidContent setTab(DeferredHolder<CreativeModeTab, CreativeModeTab> tab) {
        this._tab = tab;
        return this;
    }

    public FluidStack fluid(int amount) {
        return new FluidStack(this.Source, amount);
    }
}

