/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.item;

import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;

public class ItemHandlerToItemContainerAdapter
implements ItemContainer {
    private final IItemHandler itemHandler;

    public ItemHandlerToItemContainerAdapter(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public int size() {
        return this.itemHandler.getSlots();
    }

    @Override
    @NotNull
    public ItemStack get(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @Override
    public void set(int slot, @Nonnull @NotNull ItemStack stack) {
        IItemHandler iItemHandler = this.itemHandler;
        if (iItemHandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)iItemHandler;
            modifiable.setStackInSlot(slot, stack);
        } else {
            this.itemHandler.extractItem(slot, Integer.MAX_VALUE, false);
            this.itemHandler.insertItem(slot, stack, false);
        }
    }

    @Override
    public boolean isValid(int slot, @NotNull ItemStack stack) {
        return this.itemHandler.isItemValid(slot, stack);
    }

    @Override
    public int getSlotCapacity(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    @Override
    @Nonnull
    @NotNull
    public IItemHandlerModifiable asHandler() {
        IItemHandlerModifiable modifiable;
        IItemHandler iItemHandler = this.itemHandler;
        return iItemHandler instanceof IItemHandlerModifiable ? (modifiable = (IItemHandlerModifiable)iItemHandler) : ItemContainer.super.asHandler();
    }
}

