/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.world.sky;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.client.renderer.world.SkyObjectDetails;
import thefloydman.linkingbooks.world.sky.HorizonInfo;
import thefloydman.linkingbooks.world.sky.SkyObject;

public class SkyUtils {
    @Nonnull
    public static List<SkyObjectDetails> generateSkyObjectDetails(@Nonnull SkyObject skyObject, long time) {
        ArrayList<SkyObjectDetails> allSkyObjectDetails = new ArrayList<SkyObjectDetails>();
        Map<SkyObject, Vector3f> systemState = SkyUtils.setupSystemState(skyObject, time);
        Pair<SkyObject, Vector3f> self = SkyUtils.getSelf(systemState);
        if (self != null) {
            systemState.remove(self.getFirst());
            float observerRotationAngle = ((SkyObject)self.getFirst()).rotationPeriod() <= 0L ? 0.0f : (float)time / (float)((SkyObject)self.getFirst()).rotationPeriod() % 1.0f * ((float)Math.PI * 2);
            Vector3f observerRotAxis = new Vector3f(0.0f, 1.0f, 0.0f);
            Quaternionf observerAxialTiltQuaternion = new Quaternionf(new AxisAngle4f(((SkyObject)self.getFirst()).axisTilt(), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
            observerAxialTiltQuaternion.transform(observerRotAxis);
            Quaternionf observerRotationQuaternion = new Quaternionf(new AxisAngle4f(observerRotationAngle, (Vector3fc)observerRotAxis));
            Quaternionf observerRotQuat = new Quaternionf((Quaternionfc)observerAxialTiltQuaternion);
            observerRotQuat.mul((Quaternionfc)observerRotationQuaternion);
            observerRotQuat.mul((Quaternionfc)new Quaternionf(new AxisAngle4f(1.5707964f, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f))));
            for (Map.Entry<SkyObject, Vector3f> entry : systemState.entrySet()) {
                Vector3f diffVec = entry.getValue().sub((Vector3fc)self.getSecond());
                Vector3f vecToObject = diffVec.normalize(new Vector3f());
                Quaternionf undoRot = new Quaternionf((Quaternionfc)observerRotQuat);
                undoRot.conjugate();
                Quaternionf quat = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)vecToObject);
                undoRot.mul((Quaternionfc)quat, quat);
                allSkyObjectDetails.add(new SkyObjectDetails(entry.getKey(), quat, diffVec.length()));
            }
            allSkyObjectDetails.sort(Comparator.comparingDouble(SkyObjectDetails::getDistance).reversed());
        }
        return allSkyObjectDetails;
    }

    public static List<HorizonInfo> generateHorizonInfos(@Nonnull SkyObject skyObject, long time) {
        List<SkyObjectDetails> foobar = SkyUtils.generateSkyObjectDetails(skyObject, time).stream().filter(skyObjectDetails -> skyObjectDetails.getSkyObject().providedLight() > 0).toList();
        ArrayList<HorizonInfo> allHorizonInfos = new ArrayList<HorizonInfo>();
        for (SkyObjectDetails skyObjectDetails2 : foobar) {
            Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
            Vector3f vecToObject = skyObjectDetails2.getQuaternion().transform(up);
            Vector3f vecToHorizon = new Vector3f(vecToObject.x(), 0.0f, vecToObject.z()).normalize(new Vector3f());
            Vector3f vecNorth = new Vector3f(1.0f, 0.0f, 0.0f);
            float horizontalAngle = vecNorth.angle((Vector3fc)vecToHorizon);
            float verticalAngle = vecToObject.angle((Vector3fc)vecToHorizon) * (float)(vecToObject.y() > vecToHorizon.y() ? 1 : -1);
            allHorizonInfos.add(new HorizonInfo(skyObjectDetails2.getSkyObject(), horizontalAngle, verticalAngle));
        }
        return allHorizonInfos;
    }

    @Nonnull
    public static Map<SkyObject, Vector3f> setupSystemState(@Nonnull SkyObject skyObject, long time) {
        HashMap<SkyObject, Vector3f> systemState = new HashMap<SkyObject, Vector3f>();
        float positionAngle = skyObject.orbitPeriod() <= 0L ? 0.0f : (float)time / (float)skyObject.orbitPeriod() % 1.0f * ((float)Math.PI * 2);
        Vector3f orbitAxis = new Vector3f(-1.0f, 0.0f, 0.0f);
        Quaternionf orbitTiltQuaternion = new Quaternionf(new AxisAngle4f(skyObject.orbitTilt(), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
        orbitTiltQuaternion.transform(orbitAxis);
        Quaternionf positionQuaternion = new Quaternionf(new AxisAngle4f(positionAngle, (Vector3fc)orbitAxis));
        Vector3f currentPosition = new Vector3f(0.0f, 0.0f, skyObject.orbitRadius());
        Quaternionf posQuat = new Quaternionf((Quaternionfc)orbitTiltQuaternion);
        positionQuaternion.mul((Quaternionfc)posQuat);
        orbitTiltQuaternion.transform(currentPosition);
        positionQuaternion.transform(currentPosition);
        systemState.put(skyObject, currentPosition);
        for (SkyObject child : skyObject.children()) {
            systemState.putAll(SkyUtils.setupSystemState(child, time).entrySet().stream().map(entry -> Map.entry((SkyObject)entry.getKey(), ((Vector3f)entry.getValue()).add((Vector3fc)currentPosition))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return systemState;
    }

    @Nullable
    public static Pair<SkyObject, Vector3f> getSelf(@Nonnull Map<SkyObject, Vector3f> systemState) {
        Optional<Pair> optional = systemState.entrySet().stream().filter(entry -> ((SkyObject)entry.getKey()).name().equals((Object)Reference.getAsResourceLocation("self"))).findFirst().map(entry -> Pair.of((Object)((SkyObject)entry.getKey()), (Object)((Vector3f)entry.getValue())));
        return optional.orElse(null);
    }
}

