/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.world.generation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.function.TriFunction;
import qouteall.q_misc_util.dimension.DimensionIntId;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.ReflectionHelper;
import thefloydman.linkingbooks.network.client.UpdateClientDimensionListMessage;
import thefloydman.linkingbooks.world.generation.AgeInfo;
import thefloydman.linkingbooks.world.generation.CloudInfo;
import thefloydman.linkingbooks.world.generation.LinkingBooksDimensionFactory;
import thefloydman.linkingbooks.world.generation.ModDimensionTypes;
import thefloydman.linkingbooks.world.sky.SkyObject;
import thefloydman.linkingbooks.world.storage.LinkingBooksSavedData;

public class AgeUtils {
    public static boolean levelExists(MinecraftServer server, ResourceKey<Level> levelKey) {
        Map map = server.forgeGetWorldMap();
        return map.containsKey(levelKey);
    }

    public static Pair<ServerLevel, Boolean> getOrCreateLevel(MinecraftServer server, ResourceKey<Level> levelKey, Component name, UUID owner, boolean overwriteBiomeSkyColor, int skyColor, int fogColor, SkyObject skyObject, List<CloudInfo> cloudInfos, TriFunction<MinecraftServer, ResourceKey<LevelStem>, ResourceKey<DimensionType>, LevelStem> levelStemFactory) {
        Map map = server.forgeGetWorldMap();
        if (map.containsKey(levelKey)) {
            return Pair.of((Object)((ServerLevel)map.get(levelKey)), (Object)false);
        }
        return Pair.of((Object)AgeUtils.createAndRegisterLevel(server, levelKey, name, owner, overwriteBiomeSkyColor, skyColor, fogColor, skyObject, cloudInfos, levelStemFactory), (Object)true);
    }

    private static ServerLevel createAndRegisterLevel(MinecraftServer server, ResourceKey<Level> levelKey, Component name, UUID owner, boolean overwriteBiomeSkyColor, int skyColor, int fogColor, SkyObject skyObject, List<CloudInfo> cloudInfos, TriFunction<MinecraftServer, ResourceKey<LevelStem>, ResourceKey<DimensionType>, LevelStem> levelStemFactory) {
        ChunkProgressListener chunkListener = ReflectionHelper.CHUNK_PROGRESS.apply(server).create(11);
        Executor executor = ReflectionHelper.EXECUTOR.apply(server);
        LevelStorageSource.LevelStorageAccess levelStorage = ReflectionHelper.LEVEL_STORAGE.apply(server);
        DerivedLevelData derivedLevelData = new DerivedLevelData(server.getWorldData(), server.getWorldData().overworldData());
        LevelStem levelStem = (LevelStem)levelStemFactory.apply((Object)server, (Object)ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)levelKey.location()), ModDimensionTypes.AGE);
        boolean isDebugWorld = server.getWorldData().isDebugWorld();
        long seed = BiomeManager.obfuscateSeed((long)server.getWorldData().worldGenOptions().seed());
        ImmutableList customSpawners = ImmutableList.of();
        boolean inputTickTime = false;
        ServerLevel newLevel = new ServerLevel(server, executor, levelStorage, (ServerLevelData)derivedLevelData, levelKey, levelStem, chunkListener, isDebugWorld, seed, (List)customSpawners, inputTickTime, null);
        server.overworld().getWorldBorder().addListener((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(newLevel.getWorldBorder()));
        AgeInfo ageInfo = new AgeInfo(1, levelKey.location(), name, owner, overwriteBiomeSkyColor, skyColor, fogColor, skyObject, cloudInfos);
        AgeUtils.registerAge(levelKey, ageInfo, newLevel);
        NeoForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)newLevel));
        return newLevel;
    }

    private static void registerAge(ResourceKey<Level> levelKey, AgeInfo ageInfo, ServerLevel serverLevel) {
        MinecraftServer server = serverLevel.getServer();
        server.forgeGetWorldMap().put(levelKey, serverLevel);
        LinkingBooksSavedData savedData = (LinkingBooksSavedData)server.overworld().getDataStorage().computeIfAbsent(LinkingBooksSavedData.factory(), "linkingbooks");
        savedData.addAge(ageInfo);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new UpdateClientDimensionListMessage((Set<ResourceKey<Level>>)ImmutableSet.of(levelKey), (Set<ResourceKey<Level>>)ImmutableSet.of()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (Reference.isImmersivePortalsLoaded()) {
            DimensionIntId.onServerDimensionChanged((MinecraftServer)server);
        }
        server.markWorldsDirty();
    }

    public static void updateAgeInfosOnStartup(MinecraftServer server) {
        LinkingBooksSavedData savedData = (LinkingBooksSavedData)server.overworld().getDataStorage().computeIfAbsent(LinkingBooksSavedData.factory(), "linkingbooks");
        HashSet<AgeInfo> updatedAges = new HashSet<AgeInfo>();
        for (AgeInfo ageInfo : savedData.ages) {
            AgeInfo updated = ageInfo.updateVersion();
            updatedAges.add(updated);
        }
        savedData.ages.clear();
        savedData.ages.addAll(updatedAges);
        savedData.setDirty();
    }

    public static void mapLevelsOnStartup(MinecraftServer server) {
        LinkingBooksSavedData savedData = (LinkingBooksSavedData)server.overworld().getDataStorage().computeIfAbsent(LinkingBooksSavedData.factory(), "linkingbooks");
        for (AgeInfo ageInfo : new HashSet<AgeInfo>(savedData.ages)) {
            AgeUtils.createAndRegisterLevel(server, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ageInfo.id()), ageInfo.name(), ageInfo.owner(), ageInfo.overrideBiomeSkyColor(), ageInfo.skyColor(), ageInfo.fogColor(), ageInfo.skyObject(), ageInfo.cloudInfos(), (TriFunction<MinecraftServer, ResourceKey<LevelStem>, ResourceKey<DimensionType>, LevelStem>)(ageInfo.id().getPath().startsWith("relto") ? LinkingBooksDimensionFactory::createRelto : LinkingBooksDimensionFactory::createDimension));
        }
    }
}

