/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.network.server;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.linking.LinkingUtils;

public record LinkMessage(LinkData linkData, boolean holdingBook, boolean isReltoBook) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LinkMessage> TYPE = new CustomPacketPayload.Type(Reference.getAsResourceLocation("link_entity"));
    public static final StreamCodec<ByteBuf, LinkMessage> STREAM_CODEC = StreamCodec.composite(LinkData.STREAM_CODEC, LinkMessage::linkData, (StreamCodec)ByteBufCodecs.BOOL, LinkMessage::holdingBook, (StreamCodec)ByteBufCodecs.BOOL, LinkMessage::isReltoBook, LinkMessage::new);

    public static void handle(LinkMessage data, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (data.isReltoBook()) {
                Pattern regExPattern = Pattern.compile("^relto_(.*)$");
                Matcher regExMatcher = regExPattern.matcher(data.linkData().dimension().getPath());
                if (regExMatcher.find()) {
                    String uuidString = regExMatcher.group(1);
                    LinkingUtils.linkToRelto((ServerPlayer)context.player(), UUID.fromString(uuidString));
                }
            } else {
                LinkingUtils.linkEntity((Entity)context.player(), data.linkData(), data.holdingBook());
            }
        });
    }

    @Nonnull
    public CustomPacketPayload.Type<LinkMessage> type() {
        return TYPE;
    }
}

