/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.network.client;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thefloydman.linkingbooks.Reference;

public record UpdateClientDimensionListMessage(Set<ResourceKey<Level>> newAges, Set<ResourceKey<Level>> deletedAges) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateClientDimensionListMessage> TYPE = new CustomPacketPayload.Type(Reference.getAsResourceLocation("update_client_dimension_list"));
    private static final Codec<ResourceKey<Level>> CODEC = Codec.of(UpdateClientDimensionListMessage::encodeLevelResourceKey, UpdateClientDimensionListMessage::decodeLevelResourceKey);
    public static final StreamCodec<ByteBuf, UpdateClientDimensionListMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)NeoForgeExtraCodecs.setOf(CODEC)), UpdateClientDimensionListMessage::newAges, (StreamCodec)ByteBufCodecs.fromCodec((Codec)NeoForgeExtraCodecs.setOf(CODEC)), UpdateClientDimensionListMessage::deletedAges, UpdateClientDimensionListMessage::new);

    private static <T> DataResult<T> encodeLevelResourceKey(ResourceKey<Level> resourceKey, DynamicOps<T> ops, T input) {
        return ResourceLocation.CODEC.encode((Object)resourceKey.location(), ops, input);
    }

    private static <T> DataResult<Pair<ResourceKey<Level>, T>> decodeLevelResourceKey(DynamicOps<T> ops, T input) {
        DataResult dataResult = ResourceLocation.CODEC.decode(ops, input);
        if (dataResult.isSuccess() && dataResult.result().isPresent()) {
            ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceLocation)((Pair)dataResult.result().get()).getFirst()));
            return new DataResult.Success((Object)Pair.of((Object)resourceKey, input), Lifecycle.stable());
        }
        return new DataResult.Error(() -> "Could not parse ResourceKey<Level>.", Optional.empty(), Lifecycle.stable());
    }

    public static void handle(UpdateClientDimensionListMessage data, IPayloadContext context) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Set levels = player.connection.levels();
            levels.addAll(data.newAges());
            levels.removeAll(data.deletedAges());
        }
    }

    @Nonnull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

