/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.network.client;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.world.generation.AgeInfo;

public record UpdateClientAgeInfoMapMessage(Map<ResourceLocation, AgeInfo> ageInfos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateClientAgeInfoMapMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"linkingbooks", (String)"update_client_age_info_map"));
    public static final StreamCodec<ByteBuf, UpdateClientAgeInfoMapMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, AgeInfo.STREAM_CODEC), UpdateClientAgeInfoMapMessage::ageInfos, UpdateClientAgeInfoMapMessage::new);

    public static void handle(UpdateClientAgeInfoMapMessage data, IPayloadContext context) {
        context.enqueueWork(() -> Reference.AGE_INFO_MAP.putAll(data.ageInfos()));
    }

    @Nonnull
    public CustomPacketPayload.Type<UpdateClientAgeInfoMapMessage> type() {
        return TYPE;
    }
}

