/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.network.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thefloydman.linkingbooks.client.ImageUtils;
import thefloydman.linkingbooks.network.server.SaveLinkingPanelImageMessage;

public record TakeScreenshotForLinkingBookMessage(UUID uuid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TakeScreenshotForLinkingBookMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"linkingbooks", (String)"take_linking_book_screenshot"));
    public static final StreamCodec<ByteBuf, TakeScreenshotForLinkingBookMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, TakeScreenshotForLinkingBookMessage::uuid, TakeScreenshotForLinkingBookMessage::new);

    public static void handle(TakeScreenshotForLinkingBookMessage data, IPayloadContext context) {
        if (RenderSystem.isOnRenderThread()) {
            TakeScreenshotForLinkingBookMessage.getScreenshot(data, context);
        } else {
            RenderSystem.recordRenderCall(() -> TakeScreenshotForLinkingBookMessage.getScreenshot(data, context));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void getScreenshot(TakeScreenshotForLinkingBookMessage data, IPayloadContext context) {
        Minecraft mc = Minecraft.getInstance();
        RenderTarget mainRenderTarget = mc.getMainRenderTarget();
        boolean wasGuiHidden = mc.options.hideGui;
        mc.options.hideGui = true;
        mainRenderTarget.bindWrite(false);
        mc.gameRenderer.renderLevel(DeltaTracker.ONE);
        mc.options.hideGui = wasGuiHidden;
        TextureTarget smallerRenderTarget = new TextureTarget(64, 42, true, false);
        ImageUtils.cropShrinkCenterRenderTarget(mainRenderTarget, (RenderTarget)smallerRenderTarget, smallerRenderTarget.width, smallerRenderTarget.height, true, false, false, true);
        NativeImage screenshotImage = Screenshot.takeScreenshot((RenderTarget)smallerRenderTarget);
        ImageUtils.NATIVE_IMAGE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)screenshotImage).ifSuccess(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                PacketDistributor.sendToServer((CustomPacketPayload)new SaveLinkingPanelImageMessage(compoundTag, data.uuid()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    @Nonnull
    public CustomPacketPayload.Type<TakeScreenshotForLinkingBookMessage> type() {
        return TYPE;
    }
}

