/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.menutype;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.menutype.ModMenuTypes;
import thefloydman.linkingbooks.network.server.AddChunkLoaderMessage;
import thefloydman.linkingbooks.network.server.RemoveChunkLoaderMessage;

public class LinkingBookMenuType
extends AbstractContainerMenu {
    public boolean holdingBook = false;
    public int bookColor = DyeColor.GREEN.getFireworkColor();
    public LinkData linkData = LinkData.EMPTY;
    public boolean canLink = false;
    public CompoundTag linkingPanelImage = new CompoundTag();
    public boolean levelExists = false;

    public LinkingBookMenuType(int containerId, Inventory playerInventory) {
        super(ModMenuTypes.LINKING_BOOK.get(), containerId);
    }

    public LinkingBookMenuType(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf extraData) {
        super(ModMenuTypes.LINKING_BOOK.get(), containerId);
        this.holdingBook = extraData.readBoolean();
        this.bookColor = extraData.readInt();
        this.linkData = (LinkData)extraData.readJsonWithCodec(LinkData.CODEC);
        this.canLink = extraData.readBoolean();
        this.levelExists = extraData.readBoolean();
        this.linkingPanelImage = extraData.readNbt();
        if (this.levelExists && Reference.isImmersivePortalsLoaded() && this.canLink) {
            PacketDistributor.sendToServer((CustomPacketPayload)new AddChunkLoaderMessage(this.linkData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean stillValid(@Nonnull Player player) {
        return true;
    }

    public void removed(@Nonnull Player player) {
        if (this.levelExists && Reference.isImmersivePortalsLoaded() && this.canLink) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RemoveChunkLoaderMessage(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        super.removed(player);
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int slotIndex) {
        return ItemStack.EMPTY;
    }
}

