/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.linking;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.linking.LinkEffectType;

public record MobEffectLinkEffectType(@Nonnull ResourceLocation typeID, Holder<MobEffect> effect, int ticks) implements LinkEffectType
{
    @Nonnull
    private final ResourceLocation typeID;
    public static final Codec<MobEffectLinkEffectType> CODEC = RecordCodecBuilder.create(codecBuilderInstance -> codecBuilderInstance.group((App)ResourceLocation.CODEC.fieldOf("type").forGetter(MobEffectLinkEffectType::typeID), (App)Options.CODEC.fieldOf("options").forGetter(mobEffectLinkEffectType -> new Options(mobEffectLinkEffectType.effect(), mobEffectLinkEffectType.ticks()))).apply((Applicative)codecBuilderInstance, (resourceLocation, options) -> new MobEffectLinkEffectType((ResourceLocation)resourceLocation, options.effect(), options.ticks())));

    @Nonnull
    public Codec<MobEffectLinkEffectType> codec() {
        return CODEC;
    }

    @Override
    public void onLinkEnd(Entity entity, LinkData linkData) {
        System.out.println(this.effect);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).addEffect(new MobEffectInstance(this.effect(), this.ticks()));
        }
    }

    @Override
    @Nonnull
    public ResourceLocation typeID() {
        return Reference.getAsResourceLocation("mob_effect");
    }

    private record Options(Holder<MobEffect> effect, int ticks) {
        private static final Codec<Options> CODEC = RecordCodecBuilder.create(codecBuilderInstance -> codecBuilderInstance.group((App)MobEffect.CODEC.fieldOf("effect").forGetter(Options::effect), (App)Codec.INT.fieldOf("ticks").forGetter(Options::ticks)).apply((Applicative)codecBuilderInstance, Options::new));
    }
}

