/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.linking;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.block.LinkTranslatorBlock;
import thefloydman.linkingbooks.block.LinkingPortalBlock;
import thefloydman.linkingbooks.block.ModBlocks;
import thefloydman.linkingbooks.block.NaraBlock;
import thefloydman.linkingbooks.blockentity.LinkTranslatorBlockEntity;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.integration.ImmersivePortalsIntegration;
import thefloydman.linkingbooks.world.storage.LinkingBooksSavedData;

public class LinkingPortalArea {
    public static Set<BlockPos> getPortalArea(@Nonnull Level level, @Nonnull BlockPos startFillerPos, @Nonnull Direction.Axis constantAxis, @Nonnull Set<BlockState> validFrameStates, @Nonnull Set<BlockState> validFillerStates, int minArea, int maxArea) {
        if (!validFillerStates.contains(level.getBlockState(startFillerPos))) {
            return new HashSet<BlockPos>();
        }
        ArrayList<BlockPos> unvisited = new ArrayList<BlockPos>();
        unvisited.add(startFillerPos);
        HashSet<BlockPos> frame = new HashSet<BlockPos>();
        HashSet<BlockPos> filler = new HashSet<BlockPos>();
        while (!unvisited.isEmpty()) {
            BlockPos currentPos = (BlockPos)unvisited.getFirst();
            unvisited.removeFirst();
            if (validFrameStates.contains(level.getBlockState(currentPos))) {
                frame.add(currentPos);
            } else if (validFillerStates.contains(level.getBlockState(currentPos))) {
                filler.add(currentPos);
                switch (constantAxis) {
                    case Y: {
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.north(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.east(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.south(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.west(), frame, filler);
                        break;
                    }
                    case Z: {
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.above(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.below(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.north(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.south(), frame, filler);
                        break;
                    }
                    default: {
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.above(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.below(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.east(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.west(), frame, filler);
                        break;
                    }
                }
            } else {
                return new HashSet<BlockPos>();
            }
            if (filler.size() <= maxArea) continue;
            return new HashSet<BlockPos>();
        }
        return filler.size() < minArea ? new HashSet<BlockPos>() : filler;
    }

    private static void addPosIfAbsent(List<BlockPos> unvisited, BlockPos blockPos, Set<BlockPos> frame, Set<BlockPos> filler) {
        if (!(unvisited.contains(blockPos) || frame.contains(blockPos) || filler.contains(blockPos))) {
            unvisited.add(blockPos);
        }
    }

    public static void createPortal(Level level, Set<BlockPos> positions, BlockState portalState, LinkData linkData) {
        for (BlockPos pos : positions) {
            level.setBlock(pos, portalState, 18);
            if (!(level instanceof ServerLevel) || linkData == null) continue;
            LinkingBooksSavedData savedData = (LinkingBooksSavedData)((ServerLevel)level).getDataStorage().computeIfAbsent(LinkingBooksSavedData.factory(), "linkingbooks");
            savedData.addLinkingPortalData(pos, linkData);
        }
    }

    public static void erasePortal(Level level, Set<BlockPos> positions) {
        BlockState blockState = Blocks.AIR.defaultBlockState();
        for (BlockPos pos : positions) {
            level.setBlock(pos, blockState, 18);
            level.setBlock(pos, blockState, 18);
            if (!(level instanceof ServerLevel)) continue;
            LinkingBooksSavedData savedData = (LinkingBooksSavedData)((ServerLevel)level).getDataStorage().computeIfAbsent(LinkingBooksSavedData.factory(), "linkingbooks");
            savedData.removeLinkingPortalData(pos);
        }
    }

    public static double[] getPortalPositionAndWidthAndHeight(Set<BlockPos> positions) {
        double xMin = ((Integer)Collections.min(positions.stream().map(Vec3i::getX).collect(Collectors.toSet()))).intValue();
        double xMax = ((Integer)Collections.max(positions.stream().map(Vec3i::getX).collect(Collectors.toSet()))).intValue();
        double posX = (xMin + xMax) / 2.0;
        double deltaX = xMax - xMin;
        double yMin = ((Integer)Collections.min(positions.stream().map(Vec3i::getY).collect(Collectors.toSet()))).intValue();
        double yMax = ((Integer)Collections.max(positions.stream().map(Vec3i::getY).collect(Collectors.toSet()))).intValue();
        double posY = (yMin + yMax) / 2.0;
        double deltaY = yMax - yMin;
        double zMin = ((Integer)Collections.min(positions.stream().map(Vec3i::getZ).collect(Collectors.toSet()))).intValue();
        double zMax = ((Integer)Collections.max(positions.stream().map(Vec3i::getZ).collect(Collectors.toSet()))).intValue();
        double posZ = (zMin + zMax) / 2.0;
        double deltaZ = zMax - zMin;
        double width = 0.0;
        double height = 0.0;
        if (deltaY != 0.0) {
            width = deltaX != 0.0 ? deltaX : deltaZ;
            height = deltaY;
        } else {
            width = deltaZ;
            height = deltaX;
        }
        return new double[]{posX, posY, posZ, width, height};
    }

    public static void tryMakeLinkingPortalOnEveryAxis(Level level, BlockPos blockPos, LinkData linkData, LinkTranslatorBlockEntity blockEntity) {
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.north(), Direction.Axis.X, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.north(), Direction.Axis.Y, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.north(), Direction.Axis.Z, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.south(), Direction.Axis.X, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.south(), Direction.Axis.Y, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.south(), Direction.Axis.Z, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.east(), Direction.Axis.X, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.east(), Direction.Axis.Y, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.east(), Direction.Axis.Z, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.west(), Direction.Axis.X, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.west(), Direction.Axis.Y, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.west(), Direction.Axis.Z, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.above(), Direction.Axis.X, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.above(), Direction.Axis.Y, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.above(), Direction.Axis.Z, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.below(), Direction.Axis.X, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.below(), Direction.Axis.Y, linkData, blockEntity);
        LinkingPortalArea.tryMakeLinkingPortalWithConstantAxis(level, blockPos.below(), Direction.Axis.Z, linkData, blockEntity);
    }

    public static void tryMakeLinkingPortalWithConstantAxis(Level world, BlockPos pos, Direction.Axis constantAxis, LinkData linkData, LinkTranslatorBlockEntity blockEntity) {
        if (world.dimension().location().equals((Object)linkData.dimension()) && !linkData.linkEffects().contains(Reference.getAsResourceLocation("intraage_linking"))) {
            return;
        }
        Set<BlockPos> portalPositions = LinkingPortalArea.getPortalArea(world, pos, constantAxis, Sets.newHashSet((Object[])Stream.concat(((NaraBlock)((Object)ModBlocks.NARA.get())).getStateDefinition().getPossibleStates().stream(), ((LinkTranslatorBlock)((Object)ModBlocks.LINK_TRANSLATOR.get())).getStateDefinition().getPossibleStates().stream()).toList().toArray(new BlockState[0])), Sets.newHashSet((Object[])((BlockState[])Blocks.AIR.getStateDefinition().getPossibleStates().toArray((Object[])new BlockState[0]))), 1, 1024);
        if (!portalPositions.isEmpty()) {
            if (Reference.isImmersivePortalsLoaded()) {
                double[] posAndDimensions = LinkingPortalArea.getPortalPositionAndWidthAndHeight(portalPositions);
                ImmersivePortalsIntegration.addImmersivePortal(world, new double[]{posAndDimensions[0], posAndDimensions[1], posAndDimensions[2]}, posAndDimensions[3], posAndDimensions[4], portalPositions, constantAxis, linkData, blockEntity);
            } else {
                LinkingPortalArea.createPortal(world, portalPositions, (BlockState)((LinkingPortalBlock)((Object)ModBlocks.LINKING_PORTAL.get())).defaultBlockState().setValue(LinkingPortalBlock.AXIS, (Comparable)constantAxis), linkData);
            }
        }
    }

    public static void tryEraseLinkingPortalOnEveryAxis(Level level, BlockPos blockPos) {
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.north(), Direction.Axis.X);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.east(), Direction.Axis.X);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.west(), Direction.Axis.X);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.south(), Direction.Axis.X);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.above(), Direction.Axis.X);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.below(), Direction.Axis.X);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.north(), Direction.Axis.Y);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.east(), Direction.Axis.Y);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.west(), Direction.Axis.Y);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.south(), Direction.Axis.Y);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.above(), Direction.Axis.Y);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.below(), Direction.Axis.Y);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.north(), Direction.Axis.Z);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.east(), Direction.Axis.Z);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.west(), Direction.Axis.Z);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.south(), Direction.Axis.Z);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.above(), Direction.Axis.Z);
        LinkingPortalArea.tryEraseLinkingPortalWithConstantAxis(level, blockPos.below(), Direction.Axis.Z);
    }

    public static void tryEraseLinkingPortalWithConstantAxis(Level level, BlockPos blockPos, Direction.Axis constantAxis) {
        Set<BlockPos> portalPositions = LinkingPortalArea.getPortalArea(level, blockPos, constantAxis, Sets.newHashSet((Object[])Stream.concat(((NaraBlock)((Object)ModBlocks.NARA.get())).getStateDefinition().getPossibleStates().stream(), ((LinkTranslatorBlock)((Object)ModBlocks.LINK_TRANSLATOR.get())).getStateDefinition().getPossibleStates().stream()).toList().toArray(new BlockState[0])), Sets.newHashSet((Object[])((BlockState[])((LinkingPortalBlock)((Object)ModBlocks.LINKING_PORTAL.get())).getStateDefinition().getPossibleStates().toArray((Object[])new BlockState[0]))), 1, 1024);
        if (!portalPositions.isEmpty()) {
            LinkingPortalArea.erasePortal(level, portalPositions);
        }
    }
}

