/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.entity;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import qouteall.imm_ptl.core.portal.Portal;
import thefloydman.linkingbooks.LinkingBooksConfig;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.component.ModDataComponents;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;
import thefloydman.linkingbooks.linking.LinkEffect;

public class LinkingPortalEntity
extends Portal {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(LinkingPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<BlockPos> BLOCKENTITY_POS = SynchedEntityData.defineId(LinkingPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);

    public LinkingPortalEntity(EntityType<?> entityType, Level world, ItemStack book, BlockPos tileEntityPos) {
        super(entityType, world);
        this.entityData.set(ITEM, (Object)(book == null ? ItemStack.EMPTY : book));
        this.entityData.set(BLOCKENTITY_POS, (Object)(tileEntityPos == null ? BlockPos.ZERO : tileEntityPos));
    }

    public LinkingPortalEntity(EntityType<?> entityType, Level world) {
        this(entityType, world, ItemStack.EMPTY, BlockPos.ZERO);
    }

    protected void defineSynchedData(@Nonnull SynchedEntityData.Builder pBuilder) {
        pBuilder.define(ITEM, (Object)ItemStack.EMPTY);
        pBuilder.define(BLOCKENTITY_POS, (Object)BlockPos.ZERO);
    }

    public BlockPos getTileEntityPos() {
        return (BlockPos)this.entityData.get(BLOCKENTITY_POS);
    }

    public void setTileEntityPos(BlockPos pos) {
        this.entityData.set(BLOCKENTITY_POS, (Object)pos);
    }

    public void onEntityTeleportedOnServer(Entity entity) {
        Player player;
        super.onEntityTeleportedOnServer(entity);
        if (!((ItemStack)this.entityData.get(ITEM)).isEmpty()) {
            LinkData linkData = (LinkData)((ItemStack)this.entityData.get(ITEM)).get(ModDataComponents.LINK_DATA);
            for (LinkEffect effect : linkData.linkEffectsAsLE()) {
                effect.onLinkStart().accept(entity, linkData);
                effect.onLinkEnd().accept(entity, linkData);
            }
        }
        if (entity instanceof Player && !(player = (Player)entity).isCreative()) {
            player.giveExperienceLevels((Integer)LinkingBooksConfig.LINKING_COST_LEVELS.get() * -1);
        }
    }

    public boolean canTeleportEntity(Entity entity) {
        boolean ip = super.canTeleportEntity(entity);
        boolean lb = true;
        if (!((ItemStack)this.entityData.get(ITEM)).isEmpty()) {
            LinkData linkData = (LinkData)((ItemStack)this.entityData.get(ITEM)).get(ModDataComponents.LINK_DATA);
            if (this.getDestWorld() == this.getOriginWorld() && !linkData.linkEffectsAsLE().contains(LinkingBooksConfig.ALWAYS_ALLOW_INTRAAGE_LINKING.get())) {
                lb = false;
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                lb = player.isCreative() || player.experienceLevel >= (Integer)LinkingBooksConfig.LINKING_COST_LEVELS.get();
            }
            for (LinkEffect effect : linkData.linkEffectsAsLE()) {
                if (effect.canStartLink().apply(entity, linkData).booleanValue() && effect.canFinishLink().apply(entity, linkData).booleanValue()) continue;
                lb = false;
                break;
            }
        }
        return ip && lb;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("book", 10)) {
            ItemStack book = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compound.getCompound("book"));
            if (book.getItem() instanceof WrittenLinkingBookItem) {
                this.entityData.set(ITEM, (Object)book);
            } else {
                this.entityData.set(ITEM, (Object)ItemStack.EMPTY);
            }
        }
        if (compound.contains("blockentity_pos", 10)) {
            this.setTileEntityPos((BlockPos)NbtUtils.readBlockPos((CompoundTag)compound, (String)"blockentity_pos").get());
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ItemStack item = (ItemStack)this.entityData.get(ITEM);
        if (!item.isEmpty()) {
            compound.put("book", item.save((HolderLookup.Provider)this.registryAccess()));
        }
        compound.put("blockentity_pos", NbtUtils.writeBlockPos((BlockPos)this.getTileEntityPos()));
    }
}

