/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.component.ModDataComponents;
import thefloydman.linkingbooks.crafting.ModRecipeSerializers;
import thefloydman.linkingbooks.item.ModItems;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;

public class LinkEffectRecipe
implements CraftingRecipe {
    private final NonNullList<Ingredient> recipeInputs;
    private final NonNullList<ResourceLocation> linkEffects;
    private ItemStack outputStack = ItemStack.EMPTY;

    public LinkEffectRecipe(NonNullList<Ingredient> recipeInput, NonNullList<ResourceLocation> linkEffects) {
        this.linkEffects = linkEffects;
        this.recipeInputs = recipeInput;
        int pos = recipeInput.indexOf((Object)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.WRITTEN_LINKING_BOOK}));
        if (pos > -1) {
            this.outputStack = ((Ingredient)recipeInput.get(pos)).getItems()[0];
        }
    }

    public boolean matches(CraftingInput inventory, @Nonnull Level level) {
        int i = 0;
        NonNullList craftingInputs = NonNullList.create();
        for (int j = 0; j < inventory.size(); ++j) {
            ItemStack stack = inventory.getItem(j);
            if (stack.isEmpty()) continue;
            ++i;
            craftingInputs.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{inventory.getItem(j)}));
        }
        boolean matches = true;
        for (Ingredient craftingInput : craftingInputs) {
            boolean foundMatch = false;
            block2: for (Ingredient recipeInput : this.recipeInputs) {
                ItemStack[] stacks;
                for (ItemStack stack : stacks = recipeInput.getItems()) {
                    if (stack.getItem() != craftingInput.getItems()[0].getItem() && !(craftingInput.getItems()[0].getItem() instanceof WrittenLinkingBookItem)) continue;
                    foundMatch = true;
                    continue block2;
                }
            }
            if (foundMatch) continue;
            matches = false;
            break;
        }
        return i == this.recipeInputs.size() + 1 && matches;
    }

    @Nonnull
    public ItemStack assemble(CraftingInput inv, @Nonnull HolderLookup.Provider registryAccess) {
        LinkData originalLinkData;
        ItemStack writtenBook = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            if (!(inv.getItem(i).getItem() instanceof WrittenLinkingBookItem)) continue;
            writtenBook = inv.getItem(i).copy();
            break;
        }
        if (!writtenBook.isEmpty() && (originalLinkData = (LinkData)writtenBook.get(ModDataComponents.LINK_DATA)) != null) {
            ArrayList<ResourceLocation> allLinkEffects = new ArrayList<ResourceLocation>();
            allLinkEffects.addAll(originalLinkData.linkEffects());
            allLinkEffects.addAll((Collection<ResourceLocation>)this.linkEffects);
            LinkData updatedLinkData = new LinkData(originalLinkData.dimension(), originalLinkData.blockPos(), originalLinkData.rotation(), originalLinkData.uuid(), allLinkEffects);
            writtenBook.set(ModDataComponents.LINK_DATA, (Object)updatedLinkData);
        }
        return writtenBook;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.recipeInputs.size();
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider pRegistries) {
        return this.outputStack;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.LINK_EFFECT.get();
    }

    @Nonnull
    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer
    implements RecipeSerializer<LinkEffectRecipe> {
        public static final StreamCodec<RegistryFriendlyByteBuf, LinkEffectRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        private static final MapCodec<LinkEffectRecipe> CODEC = RecordCodecBuilder.mapCodec(instanceBuilder -> instanceBuilder.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("additional_ingredients").flatXmap(ingredientsList -> {
            Object[] aingredient = (Ingredient[])ingredientsList.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients to add link effects");
            }
            return aingredient.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() - 1 ? DataResult.error(() -> "Too many ingredients for link effect recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() - 1)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(linkEffectRecipe -> linkEffectRecipe.recipeInputs), (App)ResourceLocation.CODEC.listOf().fieldOf("link_effects").flatXmap(effectsList -> {
            Object[] linkEffects = (ResourceLocation[])effectsList.toArray(ResourceLocation[]::new);
            if (linkEffects.length == 0) {
                return DataResult.error(() -> "No link effects for link effect recipe");
            }
            return DataResult.success((Object)NonNullList.of((Object)ResourceLocation.parse((String)"linkingbooks:none"), (Object[])linkEffects));
        }, DataResult::success).forGetter(linkEffectRecipe -> linkEffectRecipe.linkEffects)).apply((Applicative)instanceBuilder, LinkEffectRecipe::new));

        private static LinkEffectRecipe fromNetwork(RegistryFriendlyByteBuf byteBuf) {
            int ingredientsSize = (Integer)ByteBufCodecs.VAR_INT.decode((Object)byteBuf);
            NonNullList ingredientsList = NonNullList.withSize((int)ingredientsSize, (Object)Ingredient.EMPTY);
            ingredientsList.replaceAll(ingredient -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)byteBuf));
            int effectsSize = (Integer)ByteBufCodecs.VAR_INT.decode((Object)byteBuf);
            NonNullList effectsList = NonNullList.withSize((int)effectsSize, (Object)ResourceLocation.parse((String)"linkingbooks:none"));
            effectsList.replaceAll(resourceLocation -> (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)byteBuf));
            return new LinkEffectRecipe((NonNullList<Ingredient>)ingredientsList, (NonNullList<ResourceLocation>)effectsList);
        }

        private static void toNetwork(RegistryFriendlyByteBuf byteBuf, LinkEffectRecipe linkEffectRecipe) {
            ByteBufCodecs.VAR_INT.encode((Object)byteBuf, (Object)linkEffectRecipe.recipeInputs.size());
            for (Ingredient recipeInput : linkEffectRecipe.recipeInputs) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)byteBuf, (Object)recipeInput);
            }
            ByteBufCodecs.VAR_INT.encode((Object)byteBuf, (Object)linkEffectRecipe.linkEffects.size());
            for (ResourceLocation linkEffect : linkEffectRecipe.linkEffects) {
                ResourceLocation.STREAM_CODEC.encode((Object)byteBuf, (Object)linkEffect);
            }
        }

        @Nonnull
        public MapCodec<LinkEffectRecipe> codec() {
            return CODEC;
        }

        @Nonnull
        public StreamCodec<RegistryFriendlyByteBuf, LinkEffectRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

