/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.block.LinkTranslatorBlock;
import thefloydman.linkingbooks.blockentity.LinkTranslatorBlockEntity;
import thefloydman.linkingbooks.client.renderer.entity.model.LinkingBookCoverModel;
import thefloydman.linkingbooks.client.renderer.entity.model.LinkingBookPagesModel;
import thefloydman.linkingbooks.client.renderer.entity.model.ModModelLayers;
import thefloydman.linkingbooks.linking.LinkingUtils;

public class LinkTranslatorRenderer
implements BlockEntityRenderer<LinkTranslatorBlockEntity> {
    private final LinkingBookCoverModel coverModel;
    private final LinkingBookPagesModel pagesModel;

    public LinkTranslatorRenderer(BlockEntityRendererProvider.Context context) {
        this.coverModel = new LinkingBookCoverModel(context.bakeLayer(ModModelLayers.COVER));
        this.coverModel.setBookState(0.95f);
        this.pagesModel = new LinkingBookPagesModel(context.bakeLayer(ModModelLayers.PAGES));
        this.pagesModel.setBookState(0.95f);
    }

    public void render(LinkTranslatorBlockEntity tileEntity, float arg1, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int arg4, int arg5) {
        if (tileEntity.hasBook()) {
            ItemStack bookStack = tileEntity.getBook();
            int coverColor = LinkingUtils.getLinkingBookColor(bookStack, 0);
            matrixStack.pushPose();
            float rotation = 0.0f;
            double[] translate = new double[]{0.0, 0.0, 0.0};
            switch ((Direction)tileEntity.getBlockState().getValue((Property)LinkTranslatorBlock.FACING)) {
                case NORTH: {
                    rotation = 1.0f;
                    translate[0] = 0.5;
                    translate[1] = 0.5;
                    translate[2] = 0.115;
                    break;
                }
                case WEST: {
                    rotation = 2.0f;
                    translate[0] = 0.115;
                    translate[1] = 0.5;
                    translate[2] = 0.5;
                    break;
                }
                case SOUTH: {
                    rotation = 3.0f;
                    translate[0] = 0.5;
                    translate[1] = 0.5;
                    translate[2] = 0.885;
                    break;
                }
                case EAST: {
                    rotation = 0.0f;
                    translate[0] = 0.885;
                    translate[1] = 0.5;
                    translate[2] = 0.5;
                    break;
                }
                default: {
                    rotation = 1.0f;
                    translate[0] = 0.5;
                    translate[1] = 0.5;
                    translate[2] = 0.4;
                }
            }
            matrixStack.translate(translate[0], translate[1], translate[2]);
            matrixStack.mulPose(Axis.YP.rotation((float)Math.PI * rotation / 2.0f));
            matrixStack.mulPose(Axis.XP.rotation((float)Math.PI));
            matrixStack.scale(0.75f, 0.75f, 0.75f);
            VertexConsumer vertexBuilder = buffer.getBuffer(this.coverModel.renderType(Reference.Resources.LINKING_BOOK_TEXTURE));
            this.coverModel.renderToBuffer(matrixStack, vertexBuilder, arg4, arg5, coverColor);
            this.pagesModel.renderToBuffer(matrixStack, vertexBuilder, arg4, arg5, Color.WHITE.getRGB());
            matrixStack.popPose();
        }
    }
}

