/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import thefloydman.linkingbooks.client.gui.widget.BookWidget;
import thefloydman.linkingbooks.client.gui.widget.NestedWidget;

@OnlyIn(value=Dist.CLIENT)
public class PageChangeWidget
extends NestedWidget {
    private final Type type;

    public PageChangeWidget(String id, int x, int y, float z, Component narration, Screen parentScreen, float scale, Type type) {
        super(id, x, y, z, 23, 13, narration, parentScreen, scale);
        this.type = type;
    }

    @Override
    public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.getVisible()) {
            guiGraphics.pose().pushPose();
            if (this.isInside(mouseX, mouseY)) {
                guiGraphics.blitSprite(this.type.spriteHover, this.getX(), this.getY(), 1, 23, 13);
            } else {
                RenderSystem.setShaderColor((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
                guiGraphics.blitSprite(this.type.spriteNormal, this.getX(), this.getY(), 1, 23, 13);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            guiGraphics.pose().popPose();
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (!this.isInside(x, y)) {
            return false;
        }
        block3: for (GuiEventListener listener : this.listeners) {
            if (!(listener instanceof BookWidget)) continue;
            BookWidget book = (BookWidget)listener;
            switch (this.type.ordinal()) {
                case 0: {
                    book.previousPage();
                    continue block3;
                }
            }
            book.nextPage();
        }
        return true;
    }

    public static enum Type {
        BACKWARD(ResourceLocation.withDefaultNamespace((String)"widget/page_backward"), ResourceLocation.withDefaultNamespace((String)"widget/page_backward_highlighted")),
        FORWARD(ResourceLocation.withDefaultNamespace((String)"widget/page_forward"), ResourceLocation.withDefaultNamespace((String)"widget/page_forward_highlighted"));

        public final ResourceLocation spriteNormal;
        public final ResourceLocation spriteHover;

        private Type(ResourceLocation spriteNormal, ResourceLocation spriteHover) {
            this.spriteNormal = spriteNormal;
            this.spriteHover = spriteHover;
        }
    }
}

