/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.widget;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class NestedWidget
extends AbstractWidget {
    protected final String id;
    protected final Map<String, NestedWidget> children = Maps.newHashMap();
    protected final List<GuiEventListener> listeners = Lists.newArrayList();
    protected final Minecraft minecraft;
    protected final Screen parentScreen;
    public final float zLevel;
    protected final float scale;

    public NestedWidget(String id, int x, int y, float z, int width, int height, Component narration, Screen parentScreen, float scale) {
        super(x, y, width, height, narration);
        this.zLevel = z;
        this.id = id;
        this.parentScreen = parentScreen;
        this.scale = scale;
        this.minecraft = Minecraft.getInstance();
    }

    public static float zDifference(GuiGraphics guiGraphics, float zLevel) {
        FloatBuffer floatBuffer = FloatBuffer.allocate(16);
        guiGraphics.pose().last().pose().set(floatBuffer);
        float currentZ = floatBuffer.get(10);
        return zLevel - currentZ < 0.0f ? zLevel - Mth.abs((float)currentZ) : zLevel + Mth.abs((float)currentZ);
    }

    public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.getVisible()) {
            this.renderChildren(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public void renderChildren(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        for (NestedWidget widget : this.children.values()) {
            widget.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.onMouseClickChildren(mouseX, mouseY, button);
    }

    public boolean onMouseClickChildren(double mouseX, double mouseY, int button) {
        boolean eatenGeneral = false;
        for (NestedWidget widget : this.children.values()) {
            boolean eatenChild = widget.mouseClicked(mouseX, mouseY, button);
            eatenGeneral = eatenChild ? eatenChild : eatenGeneral;
        }
        return eatenGeneral;
    }

    public boolean isInside(double x, double y) {
        return this.getVisible() && x >= (double)this.getX() && x < (double)((float)this.getX() + (float)this.width * this.scale) && y >= (double)this.getY() && y < (double)((float)this.getY() + (float)this.height * this.scale);
    }

    public <T extends NestedWidget> T addChild(T widget) {
        this.children.put(widget.getId(), widget);
        return widget;
    }

    public void addListener(GuiEventListener listener) {
        this.listeners.add(listener);
    }

    public void updateWidgetNarration(@Nonnull NarrationElementOutput narrationOutput) {
    }

    public void restore(NestedWidget backup) {
    }

    public void restoreChildren(NestedWidget backup) {
        for (NestedWidget element : this.children.values()) {
            element.restore(backup.children.get(element.id));
            element.restoreChildren(backup.children.get(element.id));
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        for (NestedWidget element : this.children.values()) {
            element.setVisible(visible);
        }
    }
}

