/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.screen;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.client.gui.widget.NestedWidget;
import thefloydman.linkingbooks.client.gui.widget.ReltoBookWidget;
import thefloydman.linkingbooks.client.sound.ModSounds;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.menutype.ReltoBookMenuType;

@OnlyIn(value=Dist.CLIENT)
public class ReltoBookScreen
extends AbstractContainerScreen<ReltoBookMenuType> {
    public ReltoBookScreen(ReltoBookMenuType container, Inventory inventory, Component narration) {
        super((AbstractContainerMenu)container, inventory, narration);
        this.imageWidth = 192;
        this.imageHeight = 180;
    }

    protected void init() {
        super.init();
        LinkData linkData = new LinkData(Reference.getAsResourceLocation(String.format("relto_%s", ((ReltoBookMenuType)this.getMenu()).owner)), new BlockPos(-11, 200, 23), -180.0f, UUID.randomUUID(), List.of(Reference.getAsResourceLocation("intraage_linking")));
        String ownerUsername = Reference.PLAYER_DISPLAY_NAMES.get(((ReltoBookMenuType)this.getMenu()).owner);
        MutableComponent ageName = ownerUsername == null ? Component.translatable((String)"age.linkingbooks.name.relto") : Component.translatable((String)"age.linkingbooks.name.relto", (Object[])new Object[]{ownerUsername});
        NestedWidget linkingBook = (NestedWidget)this.addRenderableWidget((GuiEventListener)new ReltoBookWidget("relto book", this.leftPos, this.topPos, 100.0f, this.imageWidth, this.imageHeight, (Component)Component.literal((String)"Relto Book"), (Screen)this, 1.0f, linkData, (Component)ageName, ((ReltoBookMenuType)this.getMenu()).levelExists));
        linkingBook.addListener((GuiEventListener)this);
        if (this.minecraft != null && this.minecraft.player != null) {
            this.minecraft.player.playSound(ModSounds.BOOK_OPEN.get(), 0.5f, 1.0f);
        }
    }

    public void onClose() {
        if (this.minecraft != null && this.minecraft.player != null) {
            this.minecraft.player.playSound(ModSounds.BOOK_CLOSE.get());
        }
        super.onClose();
    }

    protected void renderLabels(@Nonnull GuiGraphics guiGraphics, int p_97809_, int p_97810_) {
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float p_97788_, int p_97789_, int p_97790_) {
    }
}

