/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.screen;

import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import thefloydman.linkingbooks.client.gui.book.GuiBookManager;
import thefloydman.linkingbooks.client.gui.widget.BookWidget;
import thefloydman.linkingbooks.client.gui.widget.NestedWidget;
import thefloydman.linkingbooks.client.sound.ModSounds;
import thefloydman.linkingbooks.menutype.GuidebookMenuType;

@OnlyIn(value=Dist.CLIENT)
public class GuidebookScreen
extends AbstractContainerScreen<GuidebookMenuType> {
    public GuidebookScreen(GuidebookMenuType menuType, Inventory inventory, Component narration) {
        super((AbstractContainerMenu)menuType, inventory, narration);
        this.imageWidth = 256;
        this.imageHeight = 180;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new BookWidget("guidebook", this.leftPos, this.topPos, 100.0f, this.imageWidth, this.imageHeight, new Color(80, 111, 203).getRGB(), (Component)Component.literal((String)"Guidebook"), (Screen)this, 1.0f, this.font, new ArrayList<List<Object>>(GuiBookManager.getPages().values())));
        if (this.minecraft != null && this.minecraft.player != null) {
            this.minecraft.player.playSound(ModSounds.BOOK_OPEN.get());
        }
    }

    public void onClose() {
        if (this.minecraft != null && this.minecraft.player != null) {
            this.minecraft.player.playSound(ModSounds.BOOK_CLOSE.get(), 0.5f, 1.0f);
        }
        super.onClose();
    }

    public void resize(@Nonnull Minecraft minecraft, int width, int height) {
        HashMap backupList = Maps.newHashMap(this.renderables.stream().filter(item -> item instanceof NestedWidget).map(NestedWidget.class::cast).collect(Collectors.toMap(NestedWidget::getId, Function.identity())));
        this.renderables.clear();
        super.resize(minecraft, width, height);
        for (NestedWidget element : this.renderables.stream().filter(item -> item instanceof NestedWidget).map(NestedWidget.class::cast).toList()) {
            if (backupList.get(element.getId()) == null) continue;
            element.restore((NestedWidget)((Object)backupList.get(element.getId())));
            element.restoreChildren((NestedWidget)((Object)backupList.get(element.getId())));
        }
    }

    protected void renderLabels(@Nonnull GuiGraphics guiGraphics, int p_97809_, int p_97810_) {
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float p_97788_, int p_97789_, int p_97790_) {
    }
}

