/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.render.MyRenderHelper;

@OnlyIn(value=Dist.CLIENT)
public class ImageUtils {
    public static final Codec<NativeImage> NATIVE_IMAGE_CODEC = RecordCodecBuilder.create(codecBuilderInstance -> codecBuilderInstance.group((App)Codec.INT.fieldOf("width").forGetter(NativeImage::getWidth), (App)Codec.INT.fieldOf("height").forGetter(NativeImage::getHeight), (App)Codec.INT_STREAM.fieldOf("pixels").forGetter(image -> {
        ArrayList<Integer> pixels = new ArrayList<Integer>();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                pixels.add(image.getPixelRGBA(x, y));
            }
        }
        return pixels.stream().mapToInt(Integer::intValue);
    })).apply((Applicative)codecBuilderInstance, (width, height, intStream) -> {
        int[] pixels = intStream.toArray();
        NativeImage image = new NativeImage(width.intValue(), height.intValue(), false);
        int i = 0;
        for (int y = 0; y < height && i < pixels.length; ++y) {
            for (int x = 0; x < width && i < pixels.length; ++x, ++i) {
                image.setPixelRGBA(x, y, pixels[i]);
            }
        }
        return image;
    }));

    public static void cropShrinkCenterRenderTarget(RenderTarget readRenderTarget, RenderTarget drawRenderTarget, int width, int height, boolean copyColor, boolean copyDepth, boolean copyStencil, boolean useLinearInterpolation) {
        int scale = Mth.floor((float)Math.min((float)readRenderTarget.width / (float)width, (float)readRenderTarget.height / (float)height));
        int cropWidth = width * scale;
        int cropHeight = height * scale;
        int cropX = (int)(((float)readRenderTarget.width - (float)cropWidth) / 2.0f);
        int cropY = (int)(((float)readRenderTarget.height - (float)cropHeight) / 2.0f);
        ImageUtils.cropShrinkRenderTarget(readRenderTarget, drawRenderTarget, cropX, cropY, cropWidth, cropHeight, copyColor, copyDepth, copyStencil, useLinearInterpolation);
    }

    public static void cropShrinkRenderTarget(RenderTarget readRenderTarget, RenderTarget drawRenderTarget, int x, int y, int width, int height, boolean copyColor, boolean copyDepth, boolean copyStencil, boolean useLinearInterpolation) {
        GlStateManager._glBindFramebuffer((int)36008, (int)readRenderTarget.frameBufferId);
        GlStateManager._glBindFramebuffer((int)36009, (int)drawRenderTarget.frameBufferId);
        GlStateManager._glBlitFrameBuffer((int)x, (int)y, (int)(x + width), (int)(y + height), (int)0, (int)0, (int)drawRenderTarget.width, (int)drawRenderTarget.height, (int)((copyColor ? 16384 : 0) | (copyDepth ? 256 : 0) | (copyStencil ? 1024 : 0)), (int)(useLinearInterpolation && copyColor && !copyDepth && !copyStencil ? 9729 : 9728));
    }

    public static void drawRenderTarget(RenderTarget renderTarget, boolean doUseAlphaBlend, boolean doEnableModifyAlpha, int left, int top, int viewportWidth, int viewportHeight) {
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
        CHelper.checkGlError();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.viewport((int)left, (int)(Minecraft.getInstance().getMainRenderTarget().height - viewportHeight - top), (int)viewportWidth, (int)viewportHeight);
        if (doUseAlphaBlend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        } else {
            RenderSystem.disableBlend();
        }
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)doEnableModifyAlpha);
        ShaderInstance shader = doUseAlphaBlend ? Minecraft.getInstance().gameRenderer.blitShader : MyRenderHelper.blitScreenNoBlendShader;
        Validate.notNull((Object)shader, (String)"shader is null", (Object[])new Object[0]);
        shader.setSampler("DiffuseSampler", (Object)renderTarget.getColorTextureId());
        shader.apply();
        BufferBuilder bufferBuilder = RenderSystem.renderThreadTesselator().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLIT_SCREEN);
        bufferBuilder.addVertex(0.0f, 0.0f, 0.0f);
        bufferBuilder.addVertex(1.0f, 0.0f, 0.0f);
        bufferBuilder.addVertex(1.0f, 1.0f, 0.0f);
        bufferBuilder.addVertex(0.0f, 1.0f, 0.0f);
        BufferUploader.draw((MeshData)bufferBuilder.buildOrThrow());
        shader.clear();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        CHelper.checkGlError();
    }
}

