/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import thefloydman.linkingbooks.blockentity.MarkerSwitchBlockEntity;
import thefloydman.linkingbooks.blockentity.ModBlockEntityTypes;

public class MarkerSwitchBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final VoxelShape SHAPE_BOTTOM;
    public static final VoxelShape SHAPE_TOP;
    public static final EnumProperty<DoubleBlockHalf> HALF;
    public static final MapCodec<MarkerSwitchBlock> CODEC;

    protected MarkerSwitchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPE_BOTTOM;
        }
        return SHAPE_TOP;
    }

    @Nonnull
    public VoxelShape getInteractionShape(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPE_BOTTOM;
        }
        return SHAPE_TOP;
    }

    @Nonnull
    public VoxelShape getCollisionShape(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPE_BOTTOM;
        }
        return SHAPE_TOP;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, HALF, OPEN});
    }

    public boolean useShapeForLightOcclusion(@Nonnull BlockState state) {
        return true;
    }

    public boolean isPathfindable(@Nonnull BlockState blockState, @Nonnull PathComputationType pathComputationType) {
        return false;
    }

    @Nonnull
    public InteractionResult useWithoutItem(@Nonnull BlockState blockState, Level level, @Nonnull BlockPos blockPos, @Nonnull Player player, @Nonnull BlockHitResult blockHitResult) {
        if (!level.isClientSide() && !player.isShiftKeyDown()) {
            blockState = (BlockState)blockState.cycle((Property)POWERED);
            level.setBlock(blockPos, blockState, 10);
            level.updateNeighborsAt(blockPos, (Block)this);
            level.updateNeighborsAt(blockPos.relative(((Direction)blockState.getValue((Property)FACING)).getOpposite()), (Block)this);
            level.updateNeighborsAt(blockPos.relative(((Direction)blockState.getValue((Property)FACING)).getCounterClockWise().getOpposite()), (Block)this);
            BlockPos otherPos = blockState.getValue(HALF) == DoubleBlockHalf.UPPER ? blockPos.below() : blockPos.above();
            level.updateNeighborsAt(otherPos, (Block)this);
            level.updateNeighborsAt(otherPos.relative(((Direction)blockState.getValue((Property)FACING)).getOpposite()), (Block)this);
            level.updateNeighborsAt(otherPos.relative(((Direction)blockState.getValue((Property)FACING)).getCounterClockWise().getOpposite()), (Block)this);
            level.playSound(null, blockPos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.5f, 0.5f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        world.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void neighborChanged(BlockState blockState, Level level, @Nonnull BlockPos blockPos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean notify) {
        BlockPos otherPos = blockState.getValue(HALF) == DoubleBlockHalf.UPPER ? blockPos.below() : blockPos.above();
        BlockState otherState = level.getBlockState(otherPos);
        if (otherState.getBlock() == this) {
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)((Boolean)otherState.getValue((Property)POWERED))));
            if (blockState.getValue(HALF) == DoubleBlockHalf.LOWER && level.getSignal(blockPos.below(), Direction.DOWN) > 0 || blockState.getValue(HALF) == DoubleBlockHalf.UPPER && level.getSignal(otherPos.below(), Direction.DOWN) > 0) {
                boolean changed = (Boolean)blockState.getValue((Property)OPEN) == false;
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true)), 10);
                level.setBlock(otherPos, (BlockState)otherState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true)), 10);
                if (blockState.getValue(HALF) == DoubleBlockHalf.LOWER && changed) {
                    level.playSound(null, blockPos, SoundEvents.WOODEN_TRAPDOOR_OPEN, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
                }
            } else {
                boolean changed = (Boolean)blockState.getValue((Property)OPEN);
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)), 10);
                level.setBlock(otherPos, (BlockState)otherState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)), 10);
                if (blockState.getValue(HALF) == DoubleBlockHalf.LOWER && changed) {
                    level.playSound(null, blockPos, SoundEvents.WOODEN_TRAPDOOR_CLOSE, SoundSource.BLOCKS, 1.0f, 0.5f);
                }
            }
        }
    }

    @Nonnull
    public BlockState updateShape(BlockState state, Direction direction, @Nonnull BlockState newState, @Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockPos posFrom) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue(HALF);
        if (direction.getAxis() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return newState.is((Block)this) && newState.getValue(HALF) != doubleBlockHalf ? (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)newState.getValue((Property)FACING)))).setValue((Property)POWERED, (Comparable)((Boolean)newState.getValue((Property)POWERED))) : Blocks.AIR.defaultBlockState();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, newState, world, pos, posFrom);
    }

    public int getSignal(@Nonnull BlockState state, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction direction) {
        return direction != Direction.UP && direction != Direction.DOWN && (direction == state.getValue((Property)FACING) || direction == ((Direction)state.getValue((Property)FACING)).getCounterClockWise()) && (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public int getDirectSignal(BlockState state, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction direction) {
        return (Boolean)state.getValue((Property)POWERED) != false && (direction == state.getValue((Property)FACING) || direction == ((Direction)state.getValue((Property)FACING)).getCounterClockWise()) ? 15 : 0;
    }

    public boolean isSignalSource(@Nonnull BlockState state) {
        return true;
    }

    @Nonnull
    public BlockState playerWillDestroy(Level level, @Nonnull BlockPos blockPos, @Nonnull BlockState blockState, @Nonnull Player player) {
        BlockPos blockPosBelow;
        BlockState blockStateBelow;
        DoubleBlockHalf doubleBlockHalf;
        if (!level.isClientSide() && player.isCreative() && (doubleBlockHalf = (DoubleBlockHalf)blockState.getValue(HALF)) == DoubleBlockHalf.UPPER && (blockStateBelow = level.getBlockState(blockPosBelow = blockPos.below())).getBlock() == blockState.getBlock() && blockStateBelow.getValue(HALF) == DoubleBlockHalf.LOWER) {
            level.setBlock(blockPosBelow, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, blockPosBelow, Block.getId((BlockState)blockStateBelow));
        }
        return super.playerWillDestroy(level, blockPos, blockState, player);
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ModBlockEntityTypes.MARKER_SWITCH.get().create(pos, state);
    }

    public void onRemove(BlockState blockState, @Nonnull Level level, @Nonnull BlockPos blockPos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (blockState.getBlock() != newState.getBlock() && blockState.getValue(HALF) == DoubleBlockHalf.LOWER && !level.isClientSide() && (tileEntity = level.getBlockEntity(blockPos)) instanceof MarkerSwitchBlockEntity) {
            MarkerSwitchBlockEntity markerTE = (MarkerSwitchBlockEntity)tileEntity;
            if (markerTE.hasItem()) {
                Containers.dropItemStack((Level)level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)markerTE.extractItem(0, Integer.MAX_VALUE, false));
                level.updateNeighbourForOutputSignal(blockPos, (Block)this);
            }
            super.onRemove(blockState, level, blockPos, newState, isMoving);
        }
    }

    static {
        HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
        CODEC = MarkerSwitchBlock.simpleCodec(MarkerSwitchBlock::new);
        VoxelShape bottom = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape top = Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        SHAPE_BOTTOM = Shapes.or((VoxelShape)bottom, (VoxelShape)top);
        SHAPE_TOP = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    }
}

