/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import thefloydman.linkingbooks.linking.LinkingUtils;
import thefloydman.linkingbooks.world.storage.LinkingBooksSavedData;

public class LinkingPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    protected static final VoxelShape X_SHAPE = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Y_SHAPE = Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    protected static final VoxelShape Z_SHAPE = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public LinkingPortalBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    @Nonnull
    public ItemStack getCloneItemStack(@Nonnull BlockState state, @Nonnull HitResult target, @Nonnull LevelReader level, @Nonnull BlockPos pos, @Nonnull Player player) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState blockState, @Nonnull Direction direction, BlockState blockState2, @Nonnull LevelAccessor worldAccess, @Nonnull BlockPos blockPos, @Nonnull BlockPos blockPos2) {
        return !blockState2.is((Block)this) ? Blocks.AIR.defaultBlockState() : super.updateShape(blockState, direction, blockState2, worldAccess, blockPos, blockPos2);
    }

    @Nonnull
    public VoxelShape getShape(BlockState blockState, @Nonnull BlockGetter blockView, @Nonnull BlockPos blockPos, @Nonnull CollisionContext shapeContext) {
        return switch ((Direction.Axis)blockState.getValue(AXIS)) {
            case Direction.Axis.Z -> Z_SHAPE;
            case Direction.Axis.Y -> Y_SHAPE;
            default -> X_SHAPE;
        };
    }

    public void entityInside(@Nonnull BlockState blockState, @Nonnull Level world, @Nonnull BlockPos blockPos, @Nonnull Entity entity) {
        if (world instanceof ServerLevel && !entity.isPassenger() && !entity.isVehicle() && Shapes.joinIsNotEmpty((VoxelShape)Shapes.create((AABB)entity.getBoundingBox().move((double)(-blockPos.getX()), (double)(-blockPos.getY()), (double)(-blockPos.getZ()))), (VoxelShape)blockState.getShape((BlockGetter)world, blockPos), (BooleanOp)BooleanOp.AND)) {
            LinkingBooksSavedData savedData = (LinkingBooksSavedData)((ServerLevel)world).getDataStorage().computeIfAbsent(LinkingBooksSavedData.factory(), "linkingbooks");
            LinkingUtils.linkEntity(entity, savedData.getLinkingPortalData(blockPos), false);
        }
    }

    public void onRemove(BlockState blockState, @Nonnull Level world, @Nonnull BlockPos pos, BlockState blockState2, boolean bl) {
        if (blockState.getBlock() != blockState2.getBlock() && !world.isClientSide()) {
            LinkingBooksSavedData savedData = (LinkingBooksSavedData)((ServerLevel)world).getDataStorage().computeIfAbsent(LinkingBooksSavedData.factory(), "linkingbooks");
            savedData.removeLinkingPortalData(pos);
        }
        super.onRemove(blockState, world, pos, blockState2, bl);
    }
}

