/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import thefloydman.linkingbooks.blockentity.LinkingLecternBlockEntity;
import thefloydman.linkingbooks.blockentity.ModBlockEntityTypes;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.component.ModDataComponents;
import thefloydman.linkingbooks.entity.LinkingBookEntity;
import thefloydman.linkingbooks.item.ReltoBookItem;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;
import thefloydman.linkingbooks.linking.LinkingUtils;

public class LinkingLecternBlock
extends BaseEntityBlock {
    public static final MapCodec<LinkingLecternBlock> CODEC = LinkingLecternBlock.simpleCodec(LinkingLecternBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape SHAPE_BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape SHAPE_POST = Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    public static final VoxelShape SHAPE_COMMON = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape)SHAPE_POST);
    public static final VoxelShape SHAPE_TOP_PLATE = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final VoxelShape SHAPE_COLLISION = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_TOP_PLATE);
    public static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)1.0, (double)10.0, (double)0.0, (double)5.333333, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.333333, (double)12.0, (double)0.0, (double)9.666667, (double)16.0, (double)16.0), Block.box((double)9.666667, (double)14.0, (double)0.0, (double)14.0, (double)18.0, (double)16.0), SHAPE_COMMON});
    public static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)10.0, (double)1.0, (double)16.0, (double)14.0, (double)5.333333), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)5.333333, (double)16.0, (double)16.0, (double)9.666667), Block.box((double)0.0, (double)14.0, (double)9.666667, (double)16.0, (double)18.0, (double)14.0), SHAPE_COMMON});
    public static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)10.666667, (double)10.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.333333, (double)12.0, (double)0.0, (double)10.666667, (double)16.0, (double)16.0), Block.box((double)2.0, (double)14.0, (double)0.0, (double)6.333333, (double)18.0, (double)16.0), SHAPE_COMMON});
    public static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)10.0, (double)10.666667, (double)16.0, (double)14.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)6.333333, (double)16.0, (double)16.0, (double)10.666667), Block.box((double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)18.0, (double)6.333333), SHAPE_COMMON});

    public LinkingLecternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nonnull
    protected RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nonnull
    protected VoxelShape getOcclusionShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return SHAPE_COMMON;
    }

    protected boolean useShapeForLightOcclusion(@Nonnull BlockState state) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Nonnull
    protected VoxelShape getCollisionShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE_COLLISION;
    }

    @Nonnull
    protected VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_COMMON;
        };
    }

    @Nonnull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Nonnull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nonnull
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ModBlockEntityTypes.LINKING_LECTERN.get().create(pos, state);
    }

    @Nonnull
    public MapCodec<LinkingLecternBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public InteractionResult useWithoutItem(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull BlockHitResult hit) {
        BlockEntity generic = world.getBlockEntity(pos);
        if (generic instanceof LinkingLecternBlockEntity) {
            ItemStack stack;
            Item item;
            LinkingLecternBlockEntity blockEntity = (LinkingLecternBlockEntity)generic;
            if (!world.isClientSide() && blockEntity.hasBook() && !player.isShiftKeyDown() && ((item = (stack = blockEntity.getBook()).getItem()) instanceof WrittenLinkingBookItem || item instanceof ReltoBookItem)) {
                Tag ownerTag;
                CustomData customData;
                LinkData linkData = (LinkData)stack.get(ModDataComponents.LINK_DATA);
                if (linkData != null) {
                    LinkingUtils.openLinkingBookGui((ServerPlayer)player, false, LinkingUtils.getLinkingBookColor(stack, 0), linkData, world.dimension().location());
                } else if (stack.getItem() instanceof ReltoBookItem && (customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA)) != null && (ownerTag = customData.copyTag().get("owner")) != null && ownerTag.getType() == TagTypes.getType((int)11)) {
                    LinkingUtils.openReltoBookGui((ServerPlayer)player, customData.copyTag().getUUID("owner"));
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (state.getBlock() != newState.getBlock() && (tileEntity = world.getBlockEntity(pos)) instanceof LinkingLecternBlockEntity) {
            ItemStack stack;
            LinkingLecternBlockEntity lecternTE = (LinkingLecternBlockEntity)tileEntity;
            if (lecternTE.hasBook() && ((stack = lecternTE.getBook()).getItem() instanceof WrittenLinkingBookItem || stack.getItem() instanceof ReltoBookItem)) {
                LinkingBookEntity entity = new LinkingBookEntity(world, stack.copy());
                entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                entity.setYRot(((Direction)state.getValue((Property)FACING)).toYRot() + 180.0f);
                world.addFreshEntity((Entity)entity);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    protected boolean isPathfindable(@Nonnull BlockState state, @Nonnull PathComputationType pathComputationType) {
        return false;
    }
}

