/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks;

import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.progress.ChunkProgressListenerFactory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class ReflectionHelper {
    public static final Function<MinecraftServer, ChunkProgressListenerFactory> CHUNK_PROGRESS = ReflectionHelper.getFieldGetter(MinecraftServer.class, "progressListenerFactory");
    public static final Function<MinecraftServer, Executor> EXECUTOR = ReflectionHelper.getFieldGetter(MinecraftServer.class, "executor");
    public static final Function<MinecraftServer, LevelStorageSource.LevelStorageAccess> LEVEL_STORAGE = ReflectionHelper.getFieldGetter(MinecraftServer.class, "storageSource");
    public static final BiFunction<ChunkMap, Object[], Object> DUMP_CHUNKS_METHOD = ReflectionHelper.getMethod(ChunkMap.class, "dumpChunks", Writer.class);
    public static final BiConsumer<Level, Integer> LEVEL_SKY_DARKEN = ReflectionHelper.getFieldSetter(Level.class, "skyDarken");

    public static <FIELDHOLDER, FIELDTYPE> Function<FIELDHOLDER, FIELDTYPE> getFieldGetter(Class<FIELDHOLDER> fieldHolderClass, String fieldName) {
        Field field = ObfuscationReflectionHelper.findField(fieldHolderClass, (String)fieldName);
        return instance -> {
            try {
                return field.get(instance);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <FIELDHOLDER, FIELDVALUE> BiConsumer<FIELDHOLDER, FIELDVALUE> getFieldSetter(Class<FIELDHOLDER> fieldHolderClass, String fieldName) {
        Field field = ObfuscationReflectionHelper.findField(fieldHolderClass, (String)fieldName);
        return (instance, value) -> {
            try {
                field.set(instance, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <METHODHOLDER> BiFunction<METHODHOLDER, Object[], Object> getMethod(Class<METHODHOLDER> methodHolderClass, String methodName, Class<?> ... parameterTypes) {
        Method method = ObfuscationReflectionHelper.findMethod(methodHolderClass, (String)methodName, (Class[])parameterTypes);
        return (instance, args) -> {
            try {
                return method.invoke(instance, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <CONSTRUCTORHOLDER> Function<Object[], CONSTRUCTORHOLDER> getConstructor(Class<CONSTRUCTORHOLDER> classOne, Class<?> ... parameters) {
        Constructor constructor = ObfuscationReflectionHelper.findConstructor(classOne, (Class[])parameters);
        return args -> {
            try {
                return constructor.newInstance(args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

