/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.enderzoology.client.init.ModelLayerLocations;
import fuzs.enderzoology.world.entity.monster.FallenMount;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;

public class FallenMountArmorLayer
extends RenderLayer<FallenMount, HorseModel<FallenMount>> {
    private final HorseModel<FallenMount> model;

    public FallenMountArmorLayer(RenderLayerParent<FallenMount, HorseModel<FallenMount>> renderLayerParent, EntityModelSet entityModelSet) {
        super(renderLayerParent);
        this.model = new HorseModel(entityModelSet.bakeLayer(ModelLayerLocations.FALLEN_MOUNT_ARMOR));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, FallenMount livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AnimalArmorItem animalArmorItem;
        ItemStack itemStack = livingEntity.getBodyArmorItem();
        Item item = itemStack.getItem();
        if (item instanceof AnimalArmorItem && (animalArmorItem = (AnimalArmorItem)item).getBodyType() == AnimalArmorItem.BodyType.EQUESTRIAN) {
            ((HorseModel)this.getParentModel()).copyPropertiesTo(this.model);
            this.model.prepareMobModel((AbstractHorse)livingEntity, limbSwing, limbSwingAmount, partialTicks);
            this.model.setupAnim((AbstractHorse)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            int i = itemStack.is(ItemTags.DYEABLE) ? FastColor.ARGB32.opaque((int)DyedItemColor.getOrDefault((ItemStack)itemStack, (int)-6265536)) : -1;
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)animalArmorItem.getTexture()));
            this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, i);
        }
    }
}

