/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import gripe._90.megacells.misc.CompressionService;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public record CompressionOverride(ItemStack larger, ItemStack smaller) {
    public static final Codec<Item> CODEC = Codec.STRING.comapFlatMap(str -> {
        if (str.equals("NONE")) {
            return DataResult.success((Object)Items.AIR);
        }
        try {
            ResourceLocation id = ResourceLocation.parse((String)str);
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            return item == Items.AIR && id != BuiltInRegistries.ITEM.getKey((Object)Items.AIR) ? DataResult.error(() -> "Could not find override variant item: " + str) : DataResult.success((Object)item);
        }
        catch (ResourceLocationException e) {
            return DataResult.error(e::getMessage);
        }
    }, item -> item == Items.AIR ? "NONE" : BuiltInRegistries.ITEM.getKey(item).toString()).fieldOf("variant").codec();

    @Override
    @NotNull
    public String toString() {
        return String.format("%s \u2192 %dx %s", CompressionService.variantString(this.larger), this.smaller.getCount(), CompressionService.variantString(this.smaller));
    }
}

