/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structurepiece;

import com.aetherteam.aether.Aether;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.mixin.mixins.common.accessor.ChunkAccessAccessor;
import com.aetherteam.aether.mixin.mixins.common.accessor.SpreadingSnowyDirtBlockAccessor;
import com.aetherteam.aether.world.BlockLogicUtil;
import com.aetherteam.aether.world.processor.DoubleDropsProcessor;
import com.aetherteam.aether.world.processor.GlowstonePortalAgeProcessor;
import com.aetherteam.aether.world.processor.HolystoneReplaceProcessor;
import com.aetherteam.aether.world.processor.SurfaceRuleProcessor;
import com.aetherteam.aether.world.structurepiece.AetherStructurePieceTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;

public class GlowstoneRuinedPortalPiece
extends TemplateStructurePiece {
    private final VerticalPlacement verticalPlacement;
    private final Properties properties;

    public GlowstoneRuinedPortalPiece(StructureTemplateManager structureTemplateManager, BlockPos templatePosition, VerticalPlacement verticalPlacement, Properties properties, ResourceLocation location, Rotation rotation, Mirror mirror, BlockPos pivotPos) {
        super((StructurePieceType)AetherStructurePieceTypes.RUINED_PORTAL.get(), 0, structureTemplateManager, location, location.toString(), GlowstoneRuinedPortalPiece.makeSettings(mirror, rotation, pivotPos, properties), templatePosition);
        this.verticalPlacement = verticalPlacement;
        this.properties = properties;
    }

    public GlowstoneRuinedPortalPiece(StructureTemplateManager structureTemplateManager, CompoundTag tag) {
        super((StructurePieceType)AetherStructurePieceTypes.RUINED_PORTAL.get(), tag, structureTemplateManager, location -> GlowstoneRuinedPortalPiece.makeSettings(structureTemplateManager, tag, location));
        this.verticalPlacement = VerticalPlacement.byName(tag.getString("VerticalPlacement"));
        this.properties = (Properties)Properties.CODEC.codec().parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("Properties"))).getPartialOrThrow();
    }

    public GlowstoneRuinedPortalPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        this(context.structureTemplateManager(), tag);
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
        super.addAdditionalSaveData(context, tag);
        tag.putString("Rotation", this.placeSettings.getRotation().name());
        tag.putString("Mirror", this.placeSettings.getMirror().name());
        tag.putString("VerticalPlacement", this.verticalPlacement.getName());
        Properties.CODEC.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.properties).resultOrPartial(arg_0 -> ((Logger)Aether.LOGGER).error(arg_0)).ifPresent(propertiesTag -> tag.put("Properties", propertiesTag));
    }

    private static StructurePlaceSettings makeSettings(StructureTemplateManager structureTemplateManager, CompoundTag tag, ResourceLocation location) {
        StructureTemplate structuretemplate = structureTemplateManager.getOrCreate(location);
        BlockPos blockpos = new BlockPos(structuretemplate.getSize().getX() / 2, 0, structuretemplate.getSize().getZ() / 2);
        return GlowstoneRuinedPortalPiece.makeSettings(Mirror.valueOf((String)tag.getString("Mirror")), Rotation.valueOf((String)tag.getString("Rotation")), blockpos, (Properties)Properties.CODEC.codec().parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("Properties"))).getPartialOrThrow());
    }

    private static StructurePlaceSettings makeSettings(Mirror mirror, Rotation rotation, BlockPos pos, Properties properties) {
        BlockIgnoreProcessor blockIgnoreProcessor = properties.airPocket ? BlockIgnoreProcessor.STRUCTURE_BLOCK : BlockIgnoreProcessor.STRUCTURE_AND_AIR;
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings().setRotation(rotation).setMirror(mirror).setRotationPivot(pos).addProcessor((StructureProcessor)blockIgnoreProcessor).addProcessor((StructureProcessor)new SurfaceRuleProcessor()).addProcessor((StructureProcessor)new GlowstonePortalAgeProcessor(properties.mossiness)).addProcessor((StructureProcessor)new DoubleDropsProcessor()).addProcessor((StructureProcessor)new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE));
        if (properties.replaceWithHolystone) {
            structurePlaceSettings.addProcessor((StructureProcessor)HolystoneReplaceProcessor.INSTANCE);
        }
        return structurePlaceSettings;
    }

    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        BoundingBox boundingbox = this.template.getBoundingBox(this.placeSettings, this.templatePosition);
        if (box.isInside((Vec3i)boundingbox.getCenter())) {
            box.encapsulate(boundingbox);
            super.postProcess(level, structureManager, generator, random, box, chunkPos, pos);
            this.spreadAetherGrass(random, (LevelAccessor)level);
            this.addDirtBuryingBelowPortal(random, (LevelAccessor)level);
            if (this.properties.vines || this.properties.overgrown) {
                BlockPos.betweenClosedStream((BoundingBox)this.getBoundingBox()).forEach(p_229127_ -> {
                    if (this.properties.vines) {
                        this.maybeAddVines(random, (LevelAccessor)level, (BlockPos)p_229127_);
                    }
                    if (this.properties.overgrown) {
                        this.maybeAddLeavesAbove(random, (LevelAccessor)level, (BlockPos)p_229127_);
                    }
                });
            }
        }
    }

    protected void handleDataMarker(String name, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
    }

    private void maybeAddVines(RandomSource random, LevelAccessor level, BlockPos pos) {
        Direction direction;
        BlockPos blockPos;
        BlockState relativeState;
        BlockState blockState = level.getBlockState(pos);
        if (!blockState.isAir() && !blockState.is(Blocks.VINE) && (relativeState = level.getBlockState(blockPos = pos.relative(direction = GlowstoneRuinedPortalPiece.getRandomHorizontalDirection((RandomSource)random)))).isAir() && Block.isFaceFull((VoxelShape)blockState.getCollisionShape((BlockGetter)level, pos), (Direction)direction)) {
            BooleanProperty property = VineBlock.getPropertyForFace((Direction)direction.getOpposite());
            level.setBlock(blockPos, (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)property, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void maybeAddLeavesAbove(RandomSource random, LevelAccessor level, BlockPos pos) {
        if (random.nextFloat() < 0.5f && level.getBlockState(pos).is((Block)AetherBlocks.AETHER_GRASS_BLOCK.get()) && level.getBlockState(pos.above()).isAir()) {
            level.setBlock(pos.above(), (BlockState)Blocks.JUNGLE_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void addDirtBuryingBelowPortal(RandomSource random, LevelAccessor level) {
        for (int i = this.boundingBox.minX() + 1; i < this.boundingBox.maxX(); ++i) {
            for (int j = this.boundingBox.minZ() + 1; j < this.boundingBox.maxZ(); ++j) {
                BlockPos blockPos = new BlockPos(i, this.boundingBox.minY(), j);
                if (!level.getBlockState(blockPos).is((Block)AetherBlocks.AETHER_GRASS_BLOCK.get())) continue;
                this.addDirtBuryingColumn(random, level, blockPos.below());
            }
        }
    }

    private void addDirtBuryingColumn(RandomSource random, LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        this.placeAetherDirtOrGrass(random, level, (BlockPos)mutableBlockPos);
        for (int i = 8; i > 0 && random.nextFloat() < 0.5f; --i) {
            mutableBlockPos.move(Direction.DOWN);
            this.placeAetherDirtOrGrass(random, level, (BlockPos)mutableBlockPos);
        }
    }

    private void spreadAetherGrass(RandomSource random, LevelAccessor level) {
        boolean flag = this.verticalPlacement == VerticalPlacement.ON_LAND_SURFACE || this.verticalPlacement == VerticalPlacement.ON_OCEAN_FLOOR;
        BlockPos blockPos = this.boundingBox.getCenter();
        int i = blockPos.getX();
        int j = blockPos.getZ();
        float[] afloat = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int k = afloat.length;
        int l = (this.boundingBox.getXSpan() + this.boundingBox.getZSpan()) / 2;
        int i1 = random.nextInt(Math.max(1, 8 - l / 2));
        BlockPos.MutableBlockPos mutablePos = BlockPos.ZERO.mutable();
        for (int k1 = i - k; k1 <= i + k; ++k1) {
            for (int l1 = j - k; l1 <= j + k; ++l1) {
                int i2 = Math.abs(k1 - i) + Math.abs(l1 - j);
                int j2 = Math.max(0, i2 + i1);
                if (j2 >= k) continue;
                float f = afloat[j2];
                if (!(random.nextDouble() < (double)f)) continue;
                int k2 = GlowstoneRuinedPortalPiece.getSurfaceY(level, k1, l1, this.verticalPlacement);
                int l2 = flag ? k2 : Math.min(this.boundingBox.minY(), k2);
                mutablePos.set(k1, l2, l1);
                if (Math.abs(l2 - this.boundingBox.minY()) > 3 || !this.canBlockBeReplacedByAetherGrass(level, (BlockPos)mutablePos)) continue;
                this.placeAetherDirtOrGrass(random, level, (BlockPos)mutablePos);
                if (this.properties.overgrown) {
                    this.maybeAddLeavesAbove(random, level, (BlockPos)mutablePos);
                }
                this.addDirtBuryingColumn(random, level, mutablePos.below());
            }
        }
    }

    private boolean canBlockBeReplacedByAetherGrass(LevelAccessor level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        return blockstate.is(AetherTags.Blocks.RUINED_PORTAL_GROUND_REPLACEABLE);
    }

    private void placeAetherDirtOrGrass(RandomSource random, LevelAccessor level, BlockPos pos) {
        BlockState grass = GlowstoneRuinedPortalPiece.getSurfaceBlockForPlacement(level, pos, level.getBlockState(pos));
        if (SpreadingSnowyDirtBlockAccessor.callCanBeGrass(grass, (LevelReader)level, pos)) {
            level.setBlock(pos, grass, 3);
            this.growGrassAndFlowers(random, level, pos.above());
        } else {
            level.setBlock(pos, (BlockState)((Block)AetherBlocks.AETHER_DIRT.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void growGrassAndFlowers(RandomSource random, LevelAccessor level, BlockPos pos) {
        int featureType = random.nextInt(50);
        if (random.nextInt(100) < 20 && level.isEmptyBlock(pos)) {
            if (featureType < 5 && level.getBlockState(pos.below()).is(AetherTags.Blocks.AETHER_DIRT)) {
                Block flower = random.nextBoolean() ? (Block)AetherBlocks.PURPLE_FLOWER.get() : (Block)AetherBlocks.WHITE_FLOWER.get();
                level.setBlock(pos, flower.defaultBlockState(), 2);
            } else if (random.nextInt(50) > 5) {
                level.setBlock(pos, Blocks.SHORT_GRASS.defaultBlockState(), 2);
            } else {
                DoublePlantBlock.placeAt((LevelAccessor)level, (BlockState)Blocks.TALL_GRASS.defaultBlockState(), (BlockPos)pos, (int)2);
            }
        }
    }

    private static int getSurfaceY(LevelAccessor level, int x, int z, VerticalPlacement verticalPlacement) {
        return level.getHeight(GlowstoneRuinedPortalPiece.getHeightMapType(verticalPlacement), x, z) - 1;
    }

    public static Heightmap.Types getHeightMapType(VerticalPlacement verticalPlacement) {
        return verticalPlacement == VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR : Heightmap.Types.WORLD_SURFACE;
    }

    public static BlockState getSurfaceBlockForPlacement(LevelAccessor level, BlockPos pos, BlockState originalState) {
        ServerChunkCache serverChunkCache;
        ChunkGenerator chunkGenerator;
        ChunkSource chunkSource;
        WorldGenRegion region;
        WorldGenLevel worldGenLevel;
        if (level instanceof WorldGenLevel && (!((worldGenLevel = (WorldGenLevel)level) instanceof WorldGenRegion) || !BlockLogicUtil.isOutOfBounds(pos, (region = (WorldGenRegion)worldGenLevel).getCenter())) && worldGenLevel.getBiome(pos).is(AetherTags.Biomes.HAS_RUINED_PORTAL_AETHER) && (chunkSource = worldGenLevel.getChunkSource()) instanceof ServerChunkCache && (chunkGenerator = (serverChunkCache = (ServerChunkCache)chunkSource).getGenerator()) instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings settingsHolder = (NoiseGeneratorSettings)noiseBasedChunkGenerator.generatorSettings().value();
            SurfaceRules.RuleSource surfaceRule = settingsHolder.surfaceRule();
            ChunkAccess chunkAccess = worldGenLevel.getChunk(pos);
            NoiseChunk noisechunk = ((ChunkAccessAccessor)chunkAccess).aether$getNoiseChunk();
            if (noisechunk != null) {
                CarvingContext carvingcontext = new CarvingContext(noiseBasedChunkGenerator, worldGenLevel.registryAccess(), chunkAccess.getHeightAccessorForGeneration(), noisechunk, serverChunkCache.randomState(), surfaceRule);
                Optional state = carvingcontext.topMaterial(arg_0 -> ((BiomeManager)worldGenLevel.getBiomeManager()).getBiome(arg_0), chunkAccess, pos, false);
                if (state.isPresent() && originalState.is(AetherTags.Blocks.AETHER_DIRT) && !originalState.is((Block)AetherBlocks.AETHER_DIRT.get()) && ((BlockState)state.get()).is(AetherTags.Blocks.AETHER_DIRT)) {
                    return (BlockState)state.get();
                }
            }
        }
        return (BlockState)((Block)AetherBlocks.AETHER_GRASS_BLOCK.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true));
    }

    public static class Properties {
        public static final MapCodec<Properties> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Codec.FLOAT.fieldOf("mossiness").forGetter(properties -> Float.valueOf(properties.mossiness)), (App)Codec.BOOL.fieldOf("air_pocket").forGetter(properties -> properties.airPocket), (App)Codec.BOOL.fieldOf("overgrown").forGetter(properties -> properties.overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(properties -> properties.vines), (App)Codec.BOOL.fieldOf("replace_with_holystone").forGetter(properties -> properties.replaceWithHolystone)).apply((Applicative)codec, Properties::new));
        public float mossiness;
        public boolean airPocket;
        public boolean overgrown;
        public boolean vines;
        public boolean replaceWithHolystone;

        public Properties() {
        }

        public Properties(float mossiness, boolean airPocket, boolean overgrown, boolean vines, boolean replaceWithHolystone) {
            this.mossiness = mossiness;
            this.airPocket = airPocket;
            this.overgrown = overgrown;
            this.vines = vines;
            this.replaceWithHolystone = replaceWithHolystone;
        }
    }

    public static enum VerticalPlacement implements StringRepresentable
    {
        ON_LAND_SURFACE("on_land_surface"),
        PARTLY_BURIED("partly_buried"),
        ON_OCEAN_FLOOR("on_ocean_floor");

        public static final StringRepresentable.EnumCodec<VerticalPlacement> CODEC;
        private final String name;

        private VerticalPlacement(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static VerticalPlacement byName(String name) {
            return (VerticalPlacement)CODEC.byName(name);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(VerticalPlacement::values);
        }
    }
}

