/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.feature;

import com.aetherteam.aether.world.configuration.AercloudConfiguration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class AercloudFeature
extends Feature<AercloudConfiguration> {
    public AercloudFeature(Codec<AercloudConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<AercloudConfiguration> context) {
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        boolean direction = random.nextBoolean();
        BlockPos blockPos = context.origin().offset(-random.nextInt(8), 0, (direction ? 8 : 0) - random.nextInt(8));
        AercloudConfiguration config = (AercloudConfiguration)context.config();
        BlockState blockState = config.block().getState(random, blockPos);
        for (int amount = 0; amount < config.bounds(); ++amount) {
            int xOffset = random.nextInt(2);
            int yOffset = random.nextBoolean() ? random.nextInt(3) - 1 : 0;
            int zOffset = random.nextInt(2);
            blockPos = direction ? blockPos.offset(xOffset, yOffset, -zOffset) : blockPos.offset(xOffset, yOffset, zOffset);
            for (int x = blockPos.getX(); x < blockPos.getX() + random.nextInt(2) + 3; ++x) {
                for (int y = blockPos.getY(); y < blockPos.getY() + random.nextInt(1) + 2; ++y) {
                    for (int z = blockPos.getZ(); z < blockPos.getZ() + random.nextInt(2) + 3; ++z) {
                        BlockPos newPosition = new BlockPos(x, y, z);
                        if (!level.isEmptyBlock(newPosition) || Math.abs(x - blockPos.getX()) + Math.abs(y - blockPos.getY()) + Math.abs(z - blockPos.getZ()) >= 4 + random.nextInt(2)) continue;
                        this.setBlock((LevelWriter)level, newPosition, blockState);
                    }
                }
            }
        }
        return true;
    }
}

