/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.miscellaneous.bucket;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.item.AetherItems;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SkyrootBucketItem
extends BucketItem {
    public static final Map<Supplier<? extends Item>, Supplier<? extends Item>> REPLACEMENTS = new HashMap<Supplier<? extends Item>, Supplier<? extends Item>>();

    public SkyrootBucketItem(Fluid supplier, Item.Properties properties) {
        super(supplier, properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        BlockHitResult blockhitResult = SkyrootBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockhitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)heldStack);
        }
        if (blockhitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)heldStack);
        }
        BlockPos blockPos = blockhitResult.getBlockPos();
        Direction direction = blockhitResult.getDirection();
        BlockPos relativePos = blockPos.relative(direction);
        if (level.mayInteract(player, blockPos) && player.mayUseItemAt(relativePos, direction, heldStack)) {
            BlockPos newPos;
            if (this.content == Fluids.EMPTY) {
                BlockState blockState = level.getBlockState(blockPos);
                FluidState fluidState = level.getFluidState(blockPos);
                Block block = blockState.getBlock();
                if (block instanceof BucketPickup) {
                    BucketPickup bucketPickup = (BucketPickup)block;
                    if (blockState.is(AetherTags.Blocks.ALLOWED_BUCKET_PICKUP) || fluidState.is(AetherTags.Fluids.ALLOWED_BUCKET_PICKUP)) {
                        ItemStack bucketStack = bucketPickup.pickupBlock(player, (LevelAccessor)level, blockPos, blockState);
                        if (!(bucketStack = SkyrootBucketItem.swapBucketType(bucketStack)).isEmpty()) {
                            player.awardStat(Stats.ITEM_USED.get((Object)this));
                            bucketPickup.getPickupSound(blockState).ifPresent(soundEvent -> player.playSound(soundEvent, 1.0f, 1.0f));
                            level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, blockPos);
                            ItemStack resultStack = ItemUtils.createFilledResult((ItemStack)heldStack, (Player)player, (ItemStack)bucketStack);
                            if (!level.isClientSide()) {
                                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, bucketStack);
                            }
                            return InteractionResultHolder.sidedSuccess((Object)resultStack, (boolean)level.isClientSide());
                        }
                    }
                }
                return InteractionResultHolder.fail((Object)heldStack);
            }
            BlockState blockState = level.getBlockState(blockPos);
            BlockPos blockPos2 = newPos = this.canBlockContainFluid(player, level, blockPos, blockState) ? blockPos : relativePos;
            if (this.emptyContents(player, level, newPos, blockhitResult, heldStack)) {
                this.checkExtraContent(player, level, heldStack, newPos);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, newPos, heldStack);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                return InteractionResultHolder.sidedSuccess((Object)SkyrootBucketItem.getEmptySuccessItem(heldStack, player), (boolean)level.isClientSide());
            }
            return InteractionResultHolder.fail((Object)heldStack);
        }
        return InteractionResultHolder.fail((Object)heldStack);
    }

    public static ItemStack swapBucketType(ItemStack filledStack) {
        Supplier<Item> filledItem = () -> ((ItemStack)filledStack).getItem();
        for (Map.Entry<Supplier<? extends Item>, Supplier<? extends Item>> entry : REPLACEMENTS.entrySet()) {
            if (filledItem.get() != entry.getKey().get()) continue;
            Item replacedItem = entry.getValue().get();
            ItemStack newStack = new ItemStack((ItemLike)replacedItem, 1);
            newStack.applyComponents(filledStack.getComponentsPatch());
            return newStack;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getEmptySuccessItem(ItemStack bucketStack, Player player) {
        return !player.getAbilities().instabuild ? new ItemStack((ItemLike)AetherItems.SKYROOT_BUCKET.get()) : bucketStack;
    }

    protected boolean canBlockContainFluid(Player player, Level level, BlockPos pos, BlockState state) {
        LiquidBlockContainer liquidBlockContainer;
        Block block = state.getBlock();
        return block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)level, pos, state, this.content);
    }
}

