/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.accessories.cape;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.client.AetherKeys;
import com.aetherteam.aether.item.accessories.AccessoryItem;
import com.aetherteam.aether.mixin.mixins.common.accessor.LivingEntityAccessor;
import com.aetherteam.aether.network.packet.clientbound.SetInvisibilityPacket;
import com.aetherteam.nitrogen.attachment.INBTSynchable;
import io.wispforest.accessories.api.slot.SlotReference;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class InvisibilityCloakItem
extends AccessoryItem {
    public InvisibilityCloakItem(Item.Properties properties) {
        super(properties);
    }

    public void tick(ItemStack stack, SlotReference reference) {
        AetherPlayerAttachment data;
        Player player;
        LivingEntity livingEntity = reference.entity();
        if (livingEntity.level().isClientSide() && livingEntity instanceof Player) {
            player = (Player)livingEntity;
            if (AetherKeys.INVISIBILITY_TOGGLE.consumeClick()) {
                data = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
                data.setSynched(player.getId(), INBTSynchable.Direction.SERVER, "setInvisibilityEnabled", !data.isInvisibilityEnabled());
            }
        }
        if (!livingEntity.level().isClientSide() && livingEntity instanceof Player) {
            player = (Player)livingEntity;
            data = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
            if (data.isInvisibilityEnabled()) {
                if (!((Boolean)AetherConfig.SERVER.balance_invisibility_cloak.get()).booleanValue()) {
                    data.setSynched(player.getId(), INBTSynchable.Direction.CLIENT, "setWearingInvisibilityCloak", true);
                } else if (!data.attackedWithInvisibility() && !data.isWearingInvisibilityCloak()) {
                    data.setSynched(player.getId(), INBTSynchable.Direction.CLIENT, "setWearingInvisibilityCloak", true);
                } else if (data.attackedWithInvisibility() && data.isWearingInvisibilityCloak()) {
                    data.setSynched(player.getId(), INBTSynchable.Direction.CLIENT, "setWearingInvisibilityCloak", false);
                }
            } else {
                data.setSynched(player.getId(), INBTSynchable.Direction.CLIENT, "setWearingInvisibilityCloak", false);
            }
        }
        if (!livingEntity.level().isClientSide()) {
            if (!livingEntity.isInvisible()) {
                if (livingEntity instanceof Player) {
                    player = (Player)livingEntity;
                    data = (AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER);
                    if (data.isWearingInvisibilityCloak()) {
                        player.setInvisible(true);
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SetInvisibilityPacket(player.getId(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                } else {
                    livingEntity.setInvisible(true);
                }
            } else if (livingEntity instanceof Player && !(data = (AetherPlayerAttachment)(player = (Player)livingEntity).getData(AetherDataAttachments.AETHER_PLAYER)).isWearingInvisibilityCloak()) {
                player.setInvisible(false);
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SetInvisibilityPacket(player.getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void onUnequip(ItemStack stack, SlotReference reference) {
        LivingEntity livingEntity = reference.entity();
        if (!livingEntity.level().isClientSide() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ((AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER)).setSynched(player.getId(), INBTSynchable.Direction.CLIENT, "setWearingInvisibilityCloak", false);
        }
        livingEntity.setInvisible(false);
        ((LivingEntityAccessor)livingEntity).callUpdateEffectVisibility();
    }
}

