/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.projectile.dart;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.mixin.mixins.common.accessor.PlayerAccessor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public abstract class AbstractDart
extends AbstractArrow {
    private int ticksInAir = 0;

    protected AbstractDart(EntityType<? extends AbstractDart> type, Level level) {
        super(type, level);
    }

    public AbstractDart(EntityType<? extends AbstractDart> type, Level level, LivingEntity shooter, ItemStack pickupItem, @Nullable ItemStack firedFromWeapon) {
        super(type, shooter, level, pickupItem, firedFromWeapon);
    }

    public AbstractDart(EntityType<? extends AbstractDart> type, Level level, LivingEntity shooter, Supplier<Item> pickupItem, @Nullable ItemStack firedFromWeapon) {
        super(type, shooter, level, new ItemStack((ItemLike)pickupItem.get()), firedFromWeapon);
    }

    public AbstractDart(EntityType<? extends AbstractDart> entityType, double x, double y, double z, Level level, ItemStack itemStack, ItemStack firedFromWeapon) {
        super(entityType, x, y, z, level, itemStack, firedFromWeapon);
    }

    public void tick() {
        super.tick();
        if (!this.onGround()) {
            ++this.ticksInAir;
        }
        if (this.ticksInAir > 500 && !this.level().isClientSide()) {
            this.discard();
        }
        if (this.isInLiquid()) {
            this.setNoGravity(false);
        }
    }

    protected void onHit(HitResult result) {
        Player player;
        Entity entity;
        super.onHit(result);
        if (result.getType() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)result).getEntity()) instanceof Player && (player = (Player)entity).isBlocking()) {
            PlayerAccessor playerAccessor = (PlayerAccessor)player;
            playerAccessor.callHurtCurrentlyUsedShield(3.0f);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Level level;
        Entity entity = result.getEntity();
        float f = (float)this.getDeltaMovement().length();
        double d0 = this.getBaseDamage();
        Entity owner = this.getOwner();
        DamageSource damageSource = this.damageSources().arrow((AbstractArrow)this, (Entity)(owner != null ? owner : this));
        if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            d0 = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damageSource, (float)((float)d0));
        }
        int i = Mth.ceil((double)Mth.clamp((double)((double)f * d0), (double)0.0, (double)2.147483647E9));
        if (this.isCritArrow()) {
            long j = this.random.nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if (owner instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)owner;
            livingEntity.setLastHurtMob(entity);
        }
        boolean flag = entity.getType() == EntityType.ENDERMAN;
        int k = entity.getRemainingFireTicks();
        if (this.isOnFire() && !flag) {
            entity.igniteForSeconds(5.0f);
        }
        if (entity.hurt(damageSource, (float)i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Level level2;
                LivingEntity livingentity = (LivingEntity)entity;
                this.doKnockback(livingentity, damageSource);
                if (!this.level().isClientSide() && owner instanceof LivingEntity && (level2 = this.level()) instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level2;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel, (Entity)livingentity, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(livingentity);
                if (livingentity != owner && livingentity instanceof Player && owner instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)owner;
                    if (!this.isSilent()) {
                        serverPlayer.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                    }
                }
            }
            this.playSound(this.getDefaultHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            this.discard();
        } else {
            entity.setRemainingFireTicks(k);
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            if (!this.level().isClientSide() && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            }
        }
        this.setNoGravity(false);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.setNoGravity(false);
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)AetherSoundEvents.ENTITY_DART_HIT.get();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("TicksInAir", this.ticksInAir);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("TicksInAir")) {
            this.ticksInAir = tag.getInt("TicksInAir");
        }
    }
}

