/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.projectile.crystal;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.data.resources.registries.AetherDamageTypes;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.monster.dungeon.boss.SunSpirit;
import com.aetherteam.aether.entity.projectile.crystal.AbstractCrystal;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class FireCrystal
extends AbstractCrystal {
    private double xPower;
    private double yPower;
    private double zPower;

    public FireCrystal(EntityType<? extends FireCrystal> entityType, Level level) {
        super(entityType, level);
    }

    public FireCrystal(Level level, Entity shooter) {
        this((EntityType<? extends FireCrystal>)((EntityType)AetherEntityTypes.FIRE_CRYSTAL.get()), level);
        this.setOwner(shooter);
        this.setPos(shooter.getX(), shooter.getY() + 1.0, shooter.getZ());
        float rotation = this.random.nextFloat() * 360.0f;
        this.xPower = (double)Mth.sin((float)rotation) * 0.5;
        this.zPower = (double)(-Mth.cos((float)rotation)) * 0.5;
        this.yPower = (double)Mth.sin((float)(this.random.nextFloat() * 360.0f)) * 0.45;
        double verticalOffset = 1.0 - Math.abs(this.yPower);
        this.xPower *= verticalOffset;
        this.zPower *= verticalOffset;
        this.setDeltaMovement(this.xPower, this.yPower, this.zPower);
    }

    @Override
    protected void tickMovement() {
        SunSpirit sunSpirit;
        Entity entity;
        if (!this.level().isClientSide() && (this.getOwner() == null || !this.getOwner().isAlive() || (entity = this.getOwner()) instanceof SunSpirit && (sunSpirit = (SunSpirit)entity).getDungeon() != null && sunSpirit.getDungeon().dungeonPlayers().isEmpty())) {
            if (this.getImpactExplosionSoundEvent() != null) {
                this.playSound(this.getImpactExplosionSoundEvent(), 1.0f, 1.0f);
            }
            this.discard();
        }
        super.tickMovement();
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity livingEntity;
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hurt(AetherDamageTypes.indirectEntityDamageSource(this.level(), AetherDamageTypes.FIRE_CRYSTAL, (Entity)this, this.getOwner()), 15.0f)) {
            livingEntity.igniteForSeconds(6.0f);
            if (this.getImpactExplosionSoundEvent() != null) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), this.getImpactExplosionSoundEvent(), SoundSource.HOSTILE, 2.0f, this.random.nextFloat() - this.random.nextFloat() * 0.2f + 1.2f);
            }
            if (!this.level().isClientSide()) {
                this.discard();
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        this.markHurt();
        switch (result.getDirection()) {
            case NORTH: 
            case SOUTH: {
                this.zPower = -this.zPower;
                break;
            }
            case UP: 
            case DOWN: {
                this.yPower = -this.yPower;
                break;
            }
            case WEST: 
            case EAST: {
                this.xPower = -this.xPower;
            }
        }
        this.setDeltaMovement(this.xPower, this.yPower, this.zPower);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.markHurt();
        Entity entity = source.getEntity();
        if (entity != null) {
            if (!this.level().isClientSide()) {
                Vec3 vec3 = entity.getLookAngle();
                this.setDeltaMovement(vec3);
                this.xPower = vec3.x() * 0.25;
                this.yPower = vec3.y() * 0.15;
                this.zPower = vec3.z() * 0.25;
                this.ticksInAir += (int)(amount * 10.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    protected ParticleOptions getExplosionParticle() {
        return ParticleTypes.FLAME;
    }

    @Override
    @Nullable
    protected SoundEvent getImpactExplosionSoundEvent() {
        return (SoundEvent)AetherSoundEvents.ENTITY_FIRE_CRYSTAL_EXPLODE.get();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putDouble("XSpeed", this.xPower);
        tag.putDouble("YSpeed", this.yPower);
        tag.putDouble("ZSpeed", this.zPower);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.xPower = tag.getDouble("XSpeed");
        this.yPower = tag.getDouble("YSpeed");
        this.zPower = tag.getDouble("ZSpeed");
    }
}

