/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.passive;

import com.aetherteam.aether.entity.ai.navigator.FallPathNavigation;
import com.aetherteam.aether.entity.passive.MountableAnimal;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class WingedAnimal
extends MountableAnimal {
    private float wingFold;
    private float wingAngle;

    public WingedAnimal(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    protected PathNavigation createNavigation(Level level) {
        return new FallPathNavigation((Mob)this, level);
    }

    @Override
    public void tick() {
        super.tick();
        AttributeInstance gravity = this.getAttribute(Attributes.GRAVITY);
        if (gravity != null) {
            double fallSpeed = Math.max(gravity.getValue() * -1.25, -0.1);
            if (this.getDeltaMovement().y() < fallSpeed && !this.playerTriedToCrouch()) {
                this.setDeltaMovement(this.getDeltaMovement().x(), fallSpeed, this.getDeltaMovement().z());
                this.hasImpulse = true;
                this.setEntityOnGround(false);
            }
        }
    }

    @Override
    public void riderTick() {
        super.riderTick();
        if (this.getControllingPassenger() instanceof Player) {
            this.checkSlowFallDistance();
        }
    }

    public float getWingFold() {
        return this.wingFold;
    }

    public void setWingFold(float wingFold) {
        this.wingFold = wingFold;
    }

    public float getWingAngle() {
        return this.wingAngle;
    }

    public void setWingAngle(float wingAngle) {
        this.wingAngle = wingAngle;
    }

    @Override
    public float getFlyingSpeed() {
        if (this.isEffectiveAi() && !this.onGround() && this.getPassengers().isEmpty()) {
            return this.getSpeed() * (0.24f / (float)Math.pow(0.91f, 3.0));
        }
        return super.getFlyingSpeed();
    }

    @Override
    public boolean canJump() {
        return this.isSaddled();
    }

    public int getMaxFallDistance() {
        return this.onGround() ? super.getMaxFallDistance() : 14;
    }
}

