/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss.goal;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.entity.monster.dungeon.boss.Slider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AvoidObstaclesGoal
extends Goal {
    private final Slider slider;

    public AvoidObstaclesGoal(Slider slider) {
        this.slider = slider;
    }

    public boolean canUse() {
        if (!this.slider.isAwake() || this.slider.isDeadOrDying() || this.slider.getMoveDelay() != 1) {
            return false;
        }
        Direction direction = this.slider.getMoveDirection();
        return direction != null && direction.getAxis() != Direction.Axis.Y;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        Vec3 targetPos = this.slider.findTargetPoint();
        if (targetPos == null) {
            return;
        }
        Direction direction = Slider.calculateDirection(targetPos.x() - this.slider.getX(), targetPos.y() - this.slider.getY(), targetPos.z() - this.slider.getZ());
        AABB collisionBox = Slider.calculateAdjacentBox(this.slider.getBoundingBox(), direction);
        BlockPos min = new BlockPos(Mth.floor((double)collisionBox.minX), Mth.floor((double)collisionBox.minY), Mth.floor((double)collisionBox.minZ));
        BlockPos max = new BlockPos(Mth.ceil((double)(collisionBox.maxX - 1.0)), Mth.ceil((double)(collisionBox.maxY - 1.0)), Mth.ceil((double)(collisionBox.maxZ - 1.0)));
        boolean isTouchingWall = false;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)min, (BlockPos)max)) {
            if (!this.slider.level().getBlockState(pos).is(AetherTags.Blocks.SLIDER_UNBREAKABLE)) continue;
            isTouchingWall = true;
            break;
        }
        if (isTouchingWall) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int y = Mth.floor((double)collisionBox.minY);
            while (isTouchingWall) {
                ++y;
                isTouchingWall = false;
                int x = Mth.floor((double)collisionBox.minX);
                while ((double)x < collisionBox.maxX) {
                    int z = Mth.floor((double)collisionBox.minZ);
                    while ((double)z < collisionBox.maxZ) {
                        if (this.slider.level().getBlockState((BlockPos)pos.set(x, y, z)).is(AetherTags.Blocks.SLIDER_UNBREAKABLE)) {
                            isTouchingWall = true;
                        }
                        ++z;
                    }
                    ++x;
                }
            }
            Vec3 currentPos = this.slider.position();
            this.slider.setTargetPoint(new Vec3(currentPos.x(), (double)y, currentPos.z()));
            this.slider.setMoveDirection(Direction.UP);
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

