/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.registries;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.item.AetherItems;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.level.block.Block;

public class AetherTrimMaterials {
    public static final ResourceKey<TrimMaterial> ZANITE = AetherTrimMaterials.createKey("zanite");
    public static final ResourceKey<TrimMaterial> GRAVITITE = AetherTrimMaterials.createKey("gravitite");
    public static final ResourceKey<TrimMaterial> GOLDEN_AMBER = AetherTrimMaterials.createKey("golden_amber");

    private static ResourceKey<TrimMaterial> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether", (String)name));
    }

    public static void bootstrap(BootstrapContext<TrimMaterial> context) {
        AetherTrimMaterials.register(context, ZANITE, (Item)AetherItems.ZANITE_GEMSTONE.get(), Style.EMPTY.withColor(8009440), 1.0f);
        AetherTrimMaterials.register(context, GRAVITITE, ((Block)AetherBlocks.ENCHANTED_GRAVITITE.get()).asItem(), Style.EMPTY.withColor(13391043), 1.0f);
        AetherTrimMaterials.register(context, GOLDEN_AMBER, ((Item)AetherItems.GOLDEN_AMBER.get()).asItem(), Style.EMPTY.withColor(16299311), 0.6f);
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> materialKey, Item ingredient, Style style, float itemModelIndex) {
        AetherTrimMaterials.register(context, materialKey, ingredient, style, itemModelIndex, Map.of());
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> materialKey, Item ingredient, Style style, float itemModelIndex, Map<Holder<ArmorMaterial>, String> overrideArmorMaterials) {
        TrimMaterial trimMaterial = TrimMaterial.create((String)materialKey.location().getPath(), (Item)ingredient, (float)itemModelIndex, (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_material", (ResourceLocation)materialKey.location())).withStyle(style), overrideArmorMaterials);
        context.register(materialKey, (Object)trimMaterial);
    }
}

