/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.entity.block.TntPresent;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TntPresentRenderer
extends EntityRenderer<TntPresent> {
    private final BlockRenderDispatcher blockRenderer;

    public TntPresentRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderer = context.getBlockRenderDispatcher();
        this.shadowRadius = 0.5f;
    }

    public void render(TntPresent present, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.5, 0.0);
        if ((float)present.getFuse() - partialTicks + 1.0f < 10.0f) {
            float f = 1.0f - ((float)present.getFuse() - partialTicks + 1.0f) / 10.0f;
            f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            f = Mth.square((float)f);
            f = Mth.square((float)f);
            float f1 = 1.0f + f * 0.3f;
            poseStack.scale(f1, f1, f1);
        }
        poseStack.translate(-0.5, -0.5, -0.5);
        TntMinecartRenderer.renderWhiteSolidBlock((BlockRenderDispatcher)this.blockRenderer, (BlockState)((Block)AetherBlocks.PRESENT.get()).defaultBlockState(), (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (present.getFuse() / 5 % 2 == 0 ? 1 : 0) != 0);
        poseStack.popPose();
        super.render((Entity)present, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(TntPresent present) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

