/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.api;

import com.aetherteam.aether.api.registers.AdvancementSoundOverride;
import com.aetherteam.aether.client.AetherSoundEvents;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;

public class AetherAdvancementSoundOverrides {
    public static final ResourceKey<Registry<AdvancementSoundOverride>> ADVANCEMENT_SOUND_OVERRIDE_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"advancement_sound_override"));
    public static final DeferredRegister<AdvancementSoundOverride> ADVANCEMENT_SOUND_OVERRIDES = DeferredRegister.create(ADVANCEMENT_SOUND_OVERRIDE_REGISTRY_KEY, (String)"aether");
    public static final Registry<AdvancementSoundOverride> ADVANCEMENT_SOUND_OVERRIDE_REGISTRY = new RegistryBuilder(ADVANCEMENT_SOUND_OVERRIDE_REGISTRY_KEY).sync(true).create();
    public static final DeferredHolder<AdvancementSoundOverride, AdvancementSoundOverride> GENERAL = ADVANCEMENT_SOUND_OVERRIDES.register("general", () -> new AdvancementSoundOverride(0, advancement -> AetherAdvancementSoundOverrides.checkRoot(advancement, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"enter_aether")), (Supplier<SoundEvent>)AetherSoundEvents.UI_TOAST_AETHER_GENERAL));
    public static final DeferredHolder<AdvancementSoundOverride, AdvancementSoundOverride> BRONZE_DUNGEON = ADVANCEMENT_SOUND_OVERRIDES.register("bronze_dungeon", () -> new AdvancementSoundOverride(10, advancement -> advancement.id().getPath().equals("bronze_dungeon"), (Supplier<SoundEvent>)AetherSoundEvents.UI_TOAST_AETHER_BRONZE));
    public static final DeferredHolder<AdvancementSoundOverride, AdvancementSoundOverride> SILVER_DUNGEON = ADVANCEMENT_SOUND_OVERRIDES.register("silver_dungeon", () -> new AdvancementSoundOverride(10, advancement -> advancement.id().getPath().equals("silver_dungeon"), (Supplier<SoundEvent>)AetherSoundEvents.UI_TOAST_AETHER_SILVER));
    public static final DeferredHolder<AdvancementSoundOverride, AdvancementSoundOverride> GOLD_DUNGEON = ADVANCEMENT_SOUND_OVERRIDES.register("gold_dungeon", () -> new AdvancementSoundOverride(10, advancement -> advancement.id().getPath().equals("gold_dungeon"), (Supplier<SoundEvent>)AetherSoundEvents.UI_TOAST_AETHER_GOLD));
    public static final DeferredHolder<AdvancementSoundOverride, AdvancementSoundOverride> EMPTY = ADVANCEMENT_SOUND_OVERRIDES.register("empty", () -> new AdvancementSoundOverride(10, advancement -> advancement.id().getPath().equals("enter_aether"), () -> SoundEvents.EMPTY));

    @Nullable
    public static AdvancementSoundOverride get(String id) {
        return (AdvancementSoundOverride)ADVANCEMENT_SOUND_OVERRIDE_REGISTRY.get(ResourceLocation.parse((String)id));
    }

    @Nullable
    public static SoundEvent retrieveOverride(AdvancementHolder advancement) {
        AdvancementSoundOverride usedOverride = null;
        for (AdvancementSoundOverride override : ADVANCEMENT_SOUND_OVERRIDES.getEntries().stream().map(DeferredHolder::value).toList()) {
            if (!override.matches(advancement) || usedOverride != null && override.priority() <= usedOverride.priority()) continue;
            usedOverride = override;
        }
        return usedOverride == null ? null : usedOverride.sound().get();
    }

    public static boolean checkRoot(AdvancementHolder holder, ResourceLocation root) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            AdvancementHolder current = holder;
            while (current != null && current.value().parent().isPresent()) {
                if (current.id().equals((Object)root)) {
                    return true;
                }
                current = player.connection.getAdvancements().get((ResourceLocation)current.value().parent().get());
            }
        }
        return false;
    }
}

