/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import vswe.stevescarts.api.modules.template.ModuleWorker;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.BlockPosHelpers;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;

public class ModuleLiquidDrainer
extends ModuleWorker {
    public ModuleLiquidDrainer(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 0;
    }

    @Override
    public boolean work() {
        return false;
    }

    public void handleLiquid(ModuleDrill drill, BlockPos pos) {
        ArrayList<BlockPos> checked = new ArrayList<BlockPos>();
        int result = this.drainAt(this.getCart().level(), drill, checked, pos, 0);
        if (result > 0 && this.doPreWork()) {
            drill.kill();
            this.startWorking((int)(2.5f * (float)result));
        } else {
            this.stopWorking();
        }
    }

    @Override
    public boolean preventAutoShutdown() {
        return true;
    }

    private int drainAt(Level level, ModuleDrill drill, ArrayList<BlockPos> checked, BlockPos pos, int buckets) {
        int drained = 0;
        BlockState state = level.getBlockState(pos);
        if (!this.isLiquid(state)) {
            return 0;
        }
        FluidStack liquid = this.getFluidStack(state, pos, !this.doPreWork());
        if (liquid != null) {
            int amount;
            if (this.doPreWork()) {
                liquid.grow(buckets * 1000);
            }
            if ((amount = this.getCart().fill(liquid, IFluidHandler.FluidAction.SIMULATE)) == liquid.getAmount()) {
                if (!this.doPreWork()) {
                    this.getCart().fill(liquid, IFluidHandler.FluidAction.EXECUTE);
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
                }
                drained += 40;
                ++buckets;
            } else if (amount == 0 && drained == 0) {
                drained = -1;
            }
        }
        checked.add(pos);
        if (checked.size() < 100 && BlockPosHelpers.getHorizontalDistToCartSquared(pos, this.getCart()) < 200.0) {
            for (int y = 1; y >= 0; --y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos next;
                        if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 1 || checked.contains(next = pos.offset(x, y, z))) continue;
                        drained += this.drainAt(level, drill, checked, next, buckets);
                    }
                }
            }
        }
        return drained;
    }

    private boolean isLiquid(BlockState state) {
        FluidState fluid = state.getFluidState();
        return !fluid.isEmpty() && fluid.isSource();
    }

    private FluidStack getFluidStack(BlockState state, BlockPos pos, boolean doDrain) {
        Block block = state.getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock fluidBlock = (LiquidBlock)block;
            BucketPickupHandlerWrapper wrapper = new BucketPickupHandlerWrapper(null, (BucketPickup)fluidBlock, this.getCart().level(), pos);
            return wrapper.drain(1000, doDrain ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE);
        }
        FluidState fluid = state.getFluidState();
        if (fluid.isEmpty() || !fluid.isSource()) {
            return null;
        }
        return new FluidStack(fluid.getType(), 1000);
    }
}

