/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.template.ModuleChest;
import vswe.stevescarts.entities.EntityMinecartModular;

public class CartInvWrapper
implements IItemHandlerModifiable {
    private final EntityMinecartModular cart;

    public CartInvWrapper(EntityMinecartModular cart) {
        this.cart = cart;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.cart.getModules() == null) {
            return;
        }
        for (ModuleBase module : this.cart.getModules()) {
            if (!(module instanceof ModuleChest)) continue;
            if (slot < module.getInventorySize()) {
                module.setStack(slot, stack);
                break;
            }
            slot -= module.getInventorySize();
        }
    }

    public int getSlots() {
        int slotCount = 0;
        if (this.cart.getModules() == null) {
            return 0;
        }
        for (ModuleBase module : this.cart.getModules()) {
            if (!(module instanceof ModuleChest)) continue;
            slotCount += module.getInventorySize();
        }
        return slotCount;
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.cart.getModules() == null) {
            return ItemStack.EMPTY;
        }
        for (ModuleBase module : this.cart.getModules()) {
            if (!(module instanceof ModuleChest)) continue;
            if (slot < module.getInventorySize()) {
                return module.getStack(slot);
            }
            slot -= module.getInventorySize();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.isEmpty()) {
            if (stackInSlot.getCount() >= Math.min(stackInSlot.getMaxStackSize(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot)) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.setStackInSlot(slot, copy);
                    this.cart.setChanged();
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                this.setStackInSlot(slot, copy);
                this.cart.setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.setStackInSlot(slot, stack.split(m));
                this.cart.setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(slot, stack);
            this.cart.setChanged();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack decrStackSize = this.removeItem(slot, m);
        this.cart.setChanged();
        return decrStackSize;
    }

    private ItemStack removeItem(int slot, int amount) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.isEmpty() || amount == 0) {
            return ItemStack.EMPTY;
        }
        stack = stack.split(amount);
        this.cart.setChanged();
        return stack;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CartInvWrapper)) {
            return false;
        }
        CartInvWrapper wrapper = (CartInvWrapper)o;
        return this.cart.equals(wrapper.cart);
    }

    public int hashCode() {
        return this.cart.hashCode();
    }
}

