/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.containers;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.blocks.tileentities.TileEntityCargo;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.containers.slots.SlotCargo;
import vswe.stevescarts.init.ModContainers;

public class ContainerCargo
extends ContainerBase {
    public short lastTarget;
    public TileEntityCargo tileEntityCargo;
    public SimpleContainerData data;

    public ContainerCargo(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (TileEntityCargo)Objects.requireNonNull(Minecraft.getInstance().level.getBlockEntity(packetBuffer.readBlockPos())), new SimpleContainerData(21));
    }

    public ContainerCargo(int id, Inventory playerInventory, TileEntityCargo tileEntityCargo, SimpleContainerData data) {
        super((MenuType)ModContainers.CONTAINER_CARGO.get(), id);
        this.tileEntityCargo = tileEntityCargo;
        this.tileEntityCargo.cargoSlots = new ArrayList();
        this.tileEntityCargo.lastLayout = -1;
        this.data = data;
        for (int i = 0; i < 60; ++i) {
            SlotCargo slot = new SlotCargo(tileEntityCargo, this, i);
            this.addSlot(slot);
            this.tileEntityCargo.cargoSlots.add(slot);
        }
        for (int k = 0; k < 3; ++k) {
            for (int j1 = 0; j1 < 9; ++j1) {
                if (playerInventory == null) continue;
                this.addSlot(new Slot((Container)playerInventory, j1 + k * 9 + 9, j1 * 18 + this.offsetX(), 104 + k * 18 + 36));
            }
        }
        for (int l = 0; l < 9; ++l) {
            if (playerInventory == null) continue;
            this.addSlot(new Slot((Container)playerInventory, l, l * 18 + this.offsetX(), 198));
        }
        this.addDataSlots((ContainerData)data);
    }

    public int getLayoutType() {
        return this.data.get(0);
    }

    public int[] getColor() {
        return new int[]{this.data.get(1), this.data.get(2), this.data.get(3), this.data.get(4)};
    }

    private int[] getAmounts() {
        return new int[]{this.data.get(17), this.data.get(18), this.data.get(19), this.data.get(20)};
    }

    public int getAmount(int id) {
        int val = this.getAmounts()[id];
        switch (val) {
            case 1: 
            case 7: {
                return 1;
            }
            case 2: 
            case 9: {
                return 3;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
            case 8: {
                return 2;
            }
            case 10: {
                return 5;
            }
        }
        return 0;
    }

    public int getAmountType(int id) {
        int val = this.getAmounts()[id];
        if (val == 0) {
            return 0;
        }
        if (val <= 6) {
            return 1;
        }
        return 2;
    }

    public boolean[] toCart() {
        return new boolean[]{this.data.get(5) == 1, this.data.get(6) == 1, this.data.get(7) == 1, this.data.get(8) == 1};
    }

    public int[] getTarget() {
        return new int[]{this.data.get(9), this.data.get(10), this.data.get(11), this.data.get(12)};
    }

    public boolean[] doReturn() {
        return new boolean[]{this.data.get(13) == 1, this.data.get(14) == 1, this.data.get(15) == 1, this.data.get(16) == 1};
    }

    protected int offsetX() {
        return 73;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }
}

