/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyCrystal;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BeeDungeonProcessor
extends StructureProcessor {
    public static final MapCodec<BeeDungeonProcessor> CODEC = MapCodec.unit(BeeDungeonProcessor::new);

    private BeeDungeonProcessor() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        if (GeneralUtils.isOutsideStructureAllowedBounds(settings, structureBlockInfoWorld.pos())) {
            return structureBlockInfoWorld;
        }
        BlockState blockState = structureBlockInfoWorld.state();
        BlockPos worldPos = structureBlockInfoWorld.pos();
        CompoundTag nbt = structureBlockInfoWorld.nbt();
        if (blockState.is(Blocks.STRUCTURE_BLOCK)) {
            CompoundTag compoundTag = structureBlockInfoWorld.nbt();
            if (compoundTag == null) {
                return structureBlockInfoWorld;
            }
            String metadata = compoundTag.getString("metadata");
            BlockState belowBlock = levelReader.getChunk(worldPos).getBlockState(worldPos);
            if (!metadata.isEmpty()) {
                nbt = null;
            }
            if (belowBlock.isAir()) {
                blockState = Blocks.CAVE_AIR.defaultBlockState();
                return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
            } else {
                RandomSource random = settings.getRandom(worldPos);
                switch (metadata) {
                    case "center": {
                        if (random.nextFloat() < 0.1f) {
                            blockState = ((Block)BzBlocks.HONEY_COCOON.get()).defaultBlockState();
                            nbt = new CompoundTag();
                            nbt.putString("LootTable", "the_bumblezone:structures/bee_dungeon");
                            return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
                        }
                        if (random.nextFloat() < 0.6f) {
                            blockState = ((Block)BzBlocks.HONEY_CRYSTAL.get()).defaultBlockState();
                            return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
                        }
                        if (random.nextFloat() < 0.6f) {
                            Optional optionalBlocks = BuiltInRegistries.BLOCK.getTag(BzTags.BEE_DUNGEON_POSSIBLE_CANDLES);
                            if (!optionalBlocks.isPresent()) return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
                            blockState = ((Block)((HolderSet.Named)optionalBlocks.get()).get(random.nextInt(((HolderSet.Named)optionalBlocks.get()).size())).value()).defaultBlockState();
                            blockState = (BlockState)blockState.setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(random.nextInt(4) + 1));
                            blockState = (BlockState)blockState.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true));
                            return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
                        }
                        blockState = Blocks.CAVE_AIR.defaultBlockState();
                        return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
                    }
                    case "inner_ring": {
                        if (random.nextFloat() < 0.35f) {
                            blockState = ((Block)BzBlocks.HONEY_CRYSTAL.get()).defaultBlockState();
                            return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
                        }
                        if (random.nextFloat() < 0.35f) {
                            Optional optionalBlocks = BuiltInRegistries.BLOCK.getTag(BzTags.BEE_DUNGEON_POSSIBLE_CANDLES);
                            if (!optionalBlocks.isPresent()) return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
                            blockState = ((Block)((HolderSet.Named)optionalBlocks.get()).get(random.nextInt(((HolderSet.Named)optionalBlocks.get()).size())).value()).defaultBlockState();
                            blockState = (BlockState)blockState.setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(random.nextInt(random.nextInt(4) + 1) + 1));
                            blockState = (BlockState)blockState.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true));
                            return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
                        }
                        blockState = Blocks.CAVE_AIR.defaultBlockState();
                        return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
                    }
                    case "outer_ring": {
                        if (random.nextFloat() < 0.45f) {
                            blockState = ((Block)BzBlocks.HONEY_CRYSTAL.get()).defaultBlockState();
                            return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
                        }
                        if (random.nextFloat() < 0.2f) {
                            Optional optionalBlocks = BuiltInRegistries.BLOCK.getTag(BzTags.BEE_DUNGEON_POSSIBLE_CANDLES);
                            if (!optionalBlocks.isPresent()) return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
                            blockState = ((Block)((HolderSet.Named)optionalBlocks.get()).get(random.nextInt(((HolderSet.Named)optionalBlocks.get()).size())).value()).defaultBlockState();
                            blockState = (BlockState)blockState.setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(random.nextInt(random.nextInt(4) + 1) + 1));
                            blockState = (BlockState)blockState.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true));
                            return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
                        }
                        blockState = Blocks.CAVE_AIR.defaultBlockState();
                        return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
                    }
                }
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
        } else if (blockState.is(Blocks.HONEYCOMB_BLOCK) || blockState.is((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
            RandomSource random = settings.getRandom(worldPos);
            boolean compatSuccess = false;
            for (ModCompat compat : ModChecker.DUNGEON_COMB_COMPATS) {
                if (!compat.checkCombSpawn(worldPos, random, levelReader, false)) continue;
                StructureTemplate.StructureBlockInfo info = compat.getHoneycomb(worldPos, random, levelReader, false);
                if (info != null) {
                    return info;
                }
                compatSuccess = true;
                break;
            }
            if (compatSuccess) return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
            blockState = random.nextFloat() < 0.4f ? Blocks.HONEYCOMB_BLOCK.defaultBlockState() : ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).defaultBlockState();
            return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
        } else if (blockState.is((Block)BzBlocks.HONEYCOMB_BROOD.get())) {
            RandomSource random = settings.getRandom(worldPos);
            blockState = random.nextFloat() < 0.6f ? (BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_BROOD.get()).defaultBlockState().setValue((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.nextInt(3)))).setValue((Property)HoneycombBrood.FACING, (Comparable)((Direction)blockState.getValue((Property)HoneycombBrood.FACING))) : (random.nextFloat() < 0.2f ? Blocks.HONEY_BLOCK.defaultBlockState() : ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).defaultBlockState());
            return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
        } else {
            RandomSource random;
            if (!blockState.is((Block)BzFluids.SUGAR_WATER_BLOCK.get()) || !((random = settings.getRandom(worldPos)).nextFloat() < 0.1f)) return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
            blockState = (BlockState)((Block)BzBlocks.HONEY_CRYSTAL.get()).defaultBlockState().setValue((Property)HoneyCrystal.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.BEE_DUNGEON_PROCESSOR.get();
    }
}

