/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.NbtOreConfiguration;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class BlockEntityCombOre
extends Feature<NbtOreConfiguration> {
    private static final Map<ResourceKey<Level>, Map<Long, ChunkAccess>> CACHED_CHUNKS_ALL_WORLDS = new WeakHashMap<ResourceKey<Level>, Map<Long, ChunkAccess>>();

    public BlockEntityCombOre(Codec<NbtOreConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<NbtOreConfiguration> context) {
        ModCompat compat;
        BlockPos.MutableBlockPos blockposMutable = new BlockPos.MutableBlockPos();
        float angleOfRotation = (float)(Math.PI * (double)context.random().nextFloat());
        float sinOfAngle = Mth.sin((float)angleOfRotation);
        float cosOfAngle = Mth.cos((float)angleOfRotation);
        float size = (float)((NbtOreConfiguration)context.config()).size * 0.5f;
        float stretchedFactor = 0.7f;
        if (((NbtOreConfiguration)context.config()).size < 10) {
            stretchedFactor = 1.0f;
        }
        int maxY = (int)(size / 3.0f);
        int minY = -maxY - 1;
        CompoundTag stateNbt = ((NbtOreConfiguration)context.config()).targetStates.get((int)0).stateNbt;
        OptionalBoolean data = OptionalBoolean.EMPTY;
        Iterator<ModCompat> iterator = ModChecker.COMB_ORE_COMPATS.iterator();
        while (iterator.hasNext() && !(data = (compat = iterator.next()).validateCombType(stateNbt)).isPresent()) {
        }
        if (data.isEmpty()) {
            return false;
        }
        for (int y = minY; y <= maxY; ++y) {
            float yModified = y;
            if (y < 0) {
                yModified = (float)y + 0.25f;
            } else if (y > 0) {
                y = (int)((float)y + 0.5f);
            }
            float percentageOfRadius = 1.0f - yModified / size * (yModified / size) * 3.0f;
            float majorRadiusSq = size * percentageOfRadius * (size * percentageOfRadius);
            float minorRadiusSq = size * stretchedFactor * percentageOfRadius * (size * stretchedFactor * percentageOfRadius);
            int x = (int)(-size);
            while ((float)x < size) {
                int z = (int)(-size);
                while ((float)z < size) {
                    float majorComp = ((float)x + 0.5f) * cosOfAngle - ((float)z + 0.5f) * sinOfAngle;
                    float minorComp = ((float)x + 0.5f) * sinOfAngle + ((float)z + 0.5f) * cosOfAngle;
                    float result = majorComp * majorComp / (majorRadiusSq * majorRadiusSq) + minorComp * minorComp / (minorRadiusSq * minorRadiusSq);
                    if (result * 100.0f < 1.0f && (x != 0 || z != 0 || !((float)(y * y) >= size * size))) {
                        blockposMutable.set(context.origin().getX() + x, context.origin().getY() + y, context.origin().getZ() + z);
                        ChunkAccess cachedChunk = this.getCachedChunk((ServerLevelAccessor)context.level(), (BlockPos)blockposMutable);
                        BlockState blockToReplace = cachedChunk.getBlockState((BlockPos)blockposMutable);
                        for (NbtOreConfiguration.TargetBlockState targetBlockState : ((NbtOreConfiguration)context.config()).targetStates) {
                            if (!targetBlockState.target.test(blockToReplace, context.random())) continue;
                            cachedChunk.setBlockState((BlockPos)blockposMutable, targetBlockState.state, false);
                            BlockEntity blockentity = ((EntityBlock)targetBlockState.state.getBlock()).newBlockEntity((BlockPos)blockposMutable, targetBlockState.state);
                            if (blockentity == null) {
                                return false;
                            }
                            blockentity.loadWithComponents(targetBlockState.stateNbt, (HolderLookup.Provider)context.level().registryAccess());
                            cachedChunk.setBlockEntity(blockentity);
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
        return true;
    }

    public ChunkAccess getCachedChunk(ServerLevelAccessor world, BlockPos blockpos) {
        long posLong;
        ChunkAccess cachedChunk;
        ResourceKey worldKey = world.getLevel().dimension();
        Map worldStorage = CACHED_CHUNKS_ALL_WORLDS.computeIfAbsent((ResourceKey<Level>)worldKey, k -> new WeakHashMap());
        if (worldStorage.size() > 9) {
            worldStorage.clear();
        }
        if ((cachedChunk = (ChunkAccess)worldStorage.get(posLong = (long)(blockpos.getX() >> 4) & 0xFFFFFFFFL | ((long)(blockpos.getZ() >> 4) & 0xFFFFFFFFL) << 32)) == null) {
            cachedChunk = world.getChunk(blockpos);
            worldStorage.put(posLong, cachedChunk);
        }
        return cachedChunk;
    }
}

