/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.mixin.world.SinglePoolElementAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.world.StructureTemplateAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.services.PlatformService;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralUtils {
    public static <T> T loadService(Class<T> service) {
        return ServiceLoader.load(service).findFirst().orElseThrow(() -> new IllegalStateException("No platform implementation found for " + service.getName()));
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, RandomSource random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static BlockPos getRandomBlockposWithinRange(LivingEntity entity, int maxRadius, int minRadius) {
        BlockPos newBeePos = BlockPos.containing((double)(entity.getX() + (double)((entity.getRandom().nextInt(maxRadius) + minRadius) * (entity.getRandom().nextBoolean() ? 1 : -1))), (double)Doubles.constrainToRange((double)(entity.getY() + (double)((entity.getRandom().nextInt(maxRadius) + minRadius) * (entity.getRandom().nextBoolean() ? 1 : -1))), (double)1.0, (double)254.0), (double)(entity.getZ() + (double)((entity.getRandom().nextInt(maxRadius) + minRadius) * (entity.getRandom().nextBoolean() ? 1 : -1))));
        return newBeePos;
    }

    public static void givePlayerItem(Player playerEntity, InteractionHand hand, ItemStack itemstackToGive, boolean giveContainerItem, boolean shrinkCurrentItem) {
        if (playerEntity.level().isClientSide()) {
            return;
        }
        ItemStack playerItem = playerEntity.getItemInHand(hand);
        ItemStack copiedPlayerItem = playerItem.copy();
        boolean instabuild = playerEntity.getAbilities().instabuild;
        if (!playerItem.isEmpty()) {
            playerEntity.awardStat(Stats.ITEM_USED.get((Object)playerItem.getItem()));
        }
        if (!instabuild && shrinkCurrentItem) {
            playerItem.shrink(1);
        }
        if (!itemstackToGive.isEmpty()) {
            if (playerItem.isEmpty()) {
                playerEntity.setItemInHand(hand, itemstackToGive);
            } else if (instabuild) {
                if (!playerEntity.getInventory().contains(itemstackToGive)) {
                    playerEntity.getInventory().add(itemstackToGive);
                }
            } else if (!playerEntity.getInventory().add(itemstackToGive)) {
                playerEntity.drop(itemstackToGive, false);
            }
        }
        if (giveContainerItem && PlatformService.INSTANCE.hasCraftingRemainder(copiedPlayerItem)) {
            ItemStack containerItem = PlatformService.INSTANCE.getCraftingRemainder(copiedPlayerItem);
            if (playerItem.isEmpty()) {
                playerEntity.setItemInHand(hand, containerItem);
            } else if (instabuild) {
                if (!playerEntity.getInventory().contains(containerItem)) {
                    playerEntity.getInventory().add(containerItem);
                }
            } else if (!playerEntity.getInventory().add(containerItem)) {
                playerEntity.drop(containerItem, false);
            }
        }
    }

    public static boolean canJigsawsAttach(StructureTemplate.StructureBlockInfo jigsaw1, StructureTemplate.StructureBlockInfo jigsaw2, String parentJoint, String parentTarget) {
        FrontAndTop prop1 = (FrontAndTop)jigsaw1.state().getValue((Property)JigsawBlock.ORIENTATION);
        FrontAndTop prop2 = (FrontAndTop)jigsaw2.state().getValue((Property)JigsawBlock.ORIENTATION);
        return prop1.front() == prop2.front().getOpposite() && (prop1.top() == prop2.top() || GeneralUtils.isRollableJoint(parentJoint, prop1)) && parentTarget.equals(GeneralUtils.getStringMicroOptimised(jigsaw2.nbt(), "name"));
    }

    private static boolean isRollableJoint(String joint, FrontAndTop prop1) {
        if (!joint.equals("rollable") && !joint.equals("aligned")) {
            return !prop1.front().getAxis().isHorizontal();
        }
        return joint.equals("rollable");
    }

    public static String getStringMicroOptimised(CompoundTag tag, String key) {
        String string;
        Tag tag2 = tag.get(key);
        if (tag2 instanceof StringTag) {
            StringTag stringTag = (StringTag)tag2;
            string = stringTag.getAsString();
        } else {
            string = "";
        }
        return string;
    }

    public static int getFirstLandYFromPos(LevelReader worldView, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.set((Vec3i)pos);
        ChunkAccess currentChunk = worldView.getChunk((BlockPos)mutable);
        BlockState currentState = currentChunk.getBlockState((BlockPos)mutable);
        while (mutable.getY() >= worldView.getMinBuildHeight() && GeneralUtils.isReplaceableByStructures(currentState)) {
            mutable.move(Direction.DOWN);
            currentState = currentChunk.getBlockState((BlockPos)mutable);
        }
        return mutable.getY();
    }

    private static boolean isReplaceableByStructures(BlockState blockState) {
        return blockState.isAir() || !blockState.getFluidState().isEmpty() || blockState.canBeReplaced() || blockState.is((Block)BzBlocks.HONEY_CRYSTAL.get());
    }

    public static BlockPos getLowestLand(ChunkGenerator chunkGenerator, RandomState randomState, BlockPos centerPos, LevelHeightAccessor heightLimitView, boolean canBeOnLiquid, boolean canBeInLiquid) {
        BlockState currentBlockstate;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set(centerPos.getX(), 1, centerPos.getZ());
        NoiseColumn blockView = chunkGenerator.getBaseColumn(mutable.getX(), mutable.getZ(), heightLimitView, randomState);
        BlockState pastBlockstate = currentBlockstate = blockView.getBlock(mutable.getY());
        while (mutable.getY() <= GeneralUtils.getMaxTerrainLimit(chunkGenerator)) {
            if (canBeInLiquid && !currentBlockstate.getFluidState().isEmpty()) {
                mutable.move(Direction.UP);
                return mutable;
            }
            if ((canBeOnLiquid || !pastBlockstate.getFluidState().isEmpty()) && currentBlockstate.isAir()) {
                mutable.move(Direction.UP);
                return mutable;
            }
            mutable.move(Direction.UP);
            pastBlockstate = currentBlockstate;
            currentBlockstate = blockView.getBlock(mutable.getY());
        }
        return mutable;
    }

    public static int getMaxTerrainLimit(ChunkGenerator chunkGenerator) {
        return chunkGenerator.getMinY() + chunkGenerator.getGenDepth();
    }

    public static void spawnItemEntity(ServerLevel serverLevel, BlockPos blockPos, ItemStack itemToSpawn, double randomXZSpeed, double ySpeed) {
        if (!itemToSpawn.isEmpty()) {
            ItemEntity itemEntity = new ItemEntity((Level)serverLevel, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.0, (double)blockPos.getZ() + 0.5, itemToSpawn);
            itemEntity.setDeltaMovement(new Vec3(serverLevel.random.nextGaussian() * randomXZSpeed, ySpeed, serverLevel.random.nextGaussian() * randomXZSpeed));
            itemEntity.setDefaultPickUpDelay();
            serverLevel.addFreshEntity((Entity)itemEntity);
        }
    }

    public static void centerAllPieces(BlockPos targetPos, List<? extends StructurePiece> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        BlockPos structureCenter = pieces.get(0).getBoundingBox().getCenter();
        int xOffset = targetPos.getX() - structureCenter.getX();
        int zOffset = targetPos.getZ() - structureCenter.getZ();
        for (StructurePiece structurePiece : pieces) {
            structurePiece.move(xOffset, 0, zOffset);
        }
    }

    public static <T> List<T> convertHoldersetToList(Optional<HolderSet.Named<T>> blockTagResult) {
        return blockTagResult.map(holders -> holders.stream().map(Holder::value).collect(Collectors.toCollection(ArrayList::new))).orElseGet(ArrayList::new);
    }

    public static <B, T extends B> boolean isInTag(Registry<B> registry, TagKey<B> key, T value) {
        return ((Holder.Reference)registry.getHolder(registry.getId(value)).orElseThrow()).is(key);
    }

    public static <T> boolean listMatches(List<T> list, List<? extends Predicate<T>> predicates) {
        if (list.size() != predicates.size()) {
            return false;
        }
        ArrayList<Predicate<T>> copiedPredicates = new ArrayList<Predicate<T>>(predicates);
        for (int i = copiedPredicates.size() - 1; i >= 0; --i) {
            block4: {
                for (int k = list.size() - 1; k >= 0; --k) {
                    if (!((Predicate)copiedPredicates.get(i)).test(list.get(k))) {
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            copiedPredicates.remove(i);
        }
        return copiedPredicates.isEmpty();
    }

    public static int split(int value, boolean upper) {
        return upper ? value >> 16 : value & 0xFFFF;
    }

    public static int merge(int upper, int lower) {
        return (upper << 16) + (lower & 0xFFFF);
    }

    public static boolean isPermissionAllowedAtSpot(Level level, Entity entity, BlockPos pos, boolean placingBlock) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).mayInteract(level, pos)) {
            return false;
        }
        return PlatformService.INSTANCE.isPermissionAllowedAtSpot(level, entity, pos, placingBlock);
    }

    public static <T extends Comparable<T>> BlockState getStateWithProperty(BlockState state, BlockState stateToCopy, Property<T> property) {
        return (BlockState)state.setValue(property, stateToCopy.getValue(property));
    }

    public static void placeInWorldWithoutNeighborUpdate(ServerLevelAccessor serverLevelAccessor, StructureTemplate structureTemplate, BlockPos blockPos, BlockPos blockPos2, StructurePlaceSettings structurePlaceSettings, RandomSource randomSource, int i) {
        if (((StructureTemplateAccessor)structureTemplate).bumblezone$getBlocks().isEmpty()) {
            return;
        }
        List list = structurePlaceSettings.getRandomPalette(((StructureTemplateAccessor)structureTemplate).bumblezone$getBlocks(), blockPos).blocks();
        if (list.isEmpty() && structurePlaceSettings.isIgnoreEntities() || structureTemplate.getSize().getX() < 1 || structureTemplate.getSize().getY() < 1 || structureTemplate.getSize().getZ() < 1) {
            return;
        }
        BoundingBox boundingBox = structurePlaceSettings.getBoundingBox();
        ArrayList list2 = Lists.newArrayListWithCapacity((int)(structurePlaceSettings.shouldApplyWaterlogging() ? list.size() : 0));
        ArrayList list3 = Lists.newArrayListWithCapacity((int)(structurePlaceSettings.shouldApplyWaterlogging() ? list.size() : 0));
        ArrayList list4 = Lists.newArrayListWithCapacity((int)list.size());
        int j = Integer.MAX_VALUE;
        int k = Integer.MAX_VALUE;
        int l = Integer.MAX_VALUE;
        int m = Integer.MIN_VALUE;
        int n = Integer.MIN_VALUE;
        int o = Integer.MIN_VALUE;
        List list5 = StructureTemplate.processBlockInfos((ServerLevelAccessor)serverLevelAccessor, (BlockPos)blockPos, (BlockPos)blockPos2, (StructurePlaceSettings)structurePlaceSettings, (List)list);
        for (StructureTemplate.StructureBlockInfo structureBlockInfo : list5) {
            BlockEntity blockEntity;
            BlockPos blockPos3 = structureBlockInfo.pos();
            if (boundingBox != null && !boundingBox.isInside((Vec3i)blockPos3)) continue;
            FluidState fluidState = structurePlaceSettings.shouldApplyWaterlogging() ? serverLevelAccessor.getFluidState(blockPos3) : null;
            BlockState blockState = structureBlockInfo.state().mirror(structurePlaceSettings.getMirror()).rotate(structurePlaceSettings.getRotation());
            if (structureBlockInfo.nbt() != null) {
                blockEntity = serverLevelAccessor.getBlockEntity(blockPos3);
                Clearable.tryClear((Object)blockEntity);
                serverLevelAccessor.setBlock(blockPos3, Blocks.BARRIER.defaultBlockState(), 20);
            }
            if (!serverLevelAccessor.setBlock(blockPos3, blockState, i)) continue;
            j = Math.min(j, blockPos3.getX());
            k = Math.min(k, blockPos3.getY());
            l = Math.min(l, blockPos3.getZ());
            m = Math.max(m, blockPos3.getX());
            n = Math.max(n, blockPos3.getY());
            o = Math.max(o, blockPos3.getZ());
            list4.add(Pair.of((Object)blockPos3, (Object)structureBlockInfo.nbt()));
            if (structureBlockInfo.nbt() != null && (blockEntity = serverLevelAccessor.getBlockEntity(blockPos3)) != null) {
                if (blockEntity instanceof RandomizableContainerBlockEntity) {
                    structureBlockInfo.nbt().putLong("LootTableSeed", randomSource.nextLong());
                }
                blockEntity.loadWithComponents(structureBlockInfo.nbt(), (HolderLookup.Provider)serverLevelAccessor.registryAccess());
            }
            if (fluidState == null) continue;
            if (blockState.getFluidState().isSource()) {
                list3.add(blockPos3);
                continue;
            }
            if (!(blockState.getBlock() instanceof LiquidBlockContainer)) continue;
            ((LiquidBlockContainer)blockState.getBlock()).placeLiquid((LevelAccessor)serverLevelAccessor, blockPos3, blockState, fluidState);
            if (fluidState.isSource()) continue;
            list2.add(blockPos3);
        }
        boolean bl = true;
        Direction[] directions = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        while (bl && !list2.isEmpty()) {
            bl = false;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                BlockState blockState2;
                Block block;
                BlockPos blockPos3 = (BlockPos)iterator.next();
                FluidState fluidState2 = serverLevelAccessor.getFluidState(blockPos3);
                for (int p = 0; p < directions.length && !fluidState2.isSource(); ++p) {
                    BlockPos blockPos5 = blockPos3.relative(directions[p]);
                    FluidState fluidState = serverLevelAccessor.getFluidState(blockPos5);
                    if (!fluidState.isSource() || list3.contains(blockPos5)) continue;
                    fluidState2 = fluidState;
                }
                if (!fluidState2.isSource() || !((block = (blockState2 = serverLevelAccessor.getBlockState(blockPos3)).getBlock()) instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)block).placeLiquid((LevelAccessor)serverLevelAccessor, blockPos3, blockState2, fluidState2);
                bl = true;
                iterator.remove();
            }
        }
        if (j <= m) {
            if (!structurePlaceSettings.getKnownShape()) {
                BitSetDiscreteVoxelShape discreteVoxelShape = new BitSetDiscreteVoxelShape(m - j + 1, n - k + 1, o - l + 1);
                for (Pair pair : list4) {
                    BlockPos blockPos6 = (BlockPos)pair.getFirst();
                    discreteVoxelShape.fill(blockPos6.getX() - j, blockPos6.getY() - k, blockPos6.getZ() - l);
                }
                StructureTemplate.updateShapeAtEdge((LevelAccessor)serverLevelAccessor, (int)i, (DiscreteVoxelShape)discreteVoxelShape, (int)j, (int)k, (int)l);
            }
            for (Pair pair : list4) {
                BlockEntity blockEntity;
                BlockPos blockPos7 = (BlockPos)pair.getFirst();
                if (!structurePlaceSettings.getKnownShape()) {
                    BlockState blockState3;
                    BlockState blockState2 = serverLevelAccessor.getBlockState(blockPos7);
                    if (blockState2 != (blockState3 = Block.updateFromNeighbourShapes((BlockState)blockState2, (LevelAccessor)serverLevelAccessor, (BlockPos)blockPos7))) {
                        serverLevelAccessor.setBlock(blockPos7, blockState3, i & 0xFFFFFFFE);
                    }
                    serverLevelAccessor.blockUpdated(blockPos7, blockState3.getBlock());
                }
                if (pair.getSecond() == null || (blockEntity = serverLevelAccessor.getBlockEntity(blockPos7)) == null) continue;
                blockEntity.setChanged();
            }
        }
        if (!structurePlaceSettings.isIgnoreEntities()) {
            GeneralUtils.placeEntities(serverLevelAccessor, structureTemplate, blockPos, structurePlaceSettings.getMirror(), structurePlaceSettings.getRotation(), structurePlaceSettings.getRotationPivot(), boundingBox, structurePlaceSettings.shouldFinalizeEntities());
        }
    }

    public static void placeInWorldWithChunkSectionCachingAndWithoutNeighborUpdate(ServerLevelAccessor serverLevelAccessor, StructureTemplate structureTemplate, BlockPos blockPos, BlockPos blockPos2, StructurePlaceSettings structurePlaceSettings, RandomSource randomSource, int i) {
        if (((StructureTemplateAccessor)structureTemplate).bumblezone$getBlocks().isEmpty()) {
            return;
        }
        List list = structurePlaceSettings.getRandomPalette(((StructureTemplateAccessor)structureTemplate).bumblezone$getBlocks(), blockPos).blocks();
        if (list.isEmpty() && structurePlaceSettings.isIgnoreEntities() || structureTemplate.getSize().getX() < 1 || structureTemplate.getSize().getY() < 1 || structureTemplate.getSize().getZ() < 1) {
            return;
        }
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)serverLevelAccessor);
        BoundingBox boundingBox = structurePlaceSettings.getBoundingBox();
        ArrayList list2 = Lists.newArrayListWithCapacity((int)(structurePlaceSettings.shouldApplyWaterlogging() ? list.size() : 0));
        ArrayList list3 = Lists.newArrayListWithCapacity((int)(structurePlaceSettings.shouldApplyWaterlogging() ? list.size() : 0));
        ArrayList list4 = Lists.newArrayListWithCapacity((int)list.size());
        int j = Integer.MAX_VALUE;
        int k = Integer.MAX_VALUE;
        int l = Integer.MAX_VALUE;
        int m = Integer.MIN_VALUE;
        int n = Integer.MIN_VALUE;
        int o = Integer.MIN_VALUE;
        List list5 = StructureTemplate.processBlockInfos((ServerLevelAccessor)serverLevelAccessor, (BlockPos)blockPos, (BlockPos)blockPos2, (StructurePlaceSettings)structurePlaceSettings, (List)list);
        for (StructureTemplate.StructureBlockInfo structureBlockInfo : list5) {
            BlockEntity blockEntity;
            BlockPos blockPos3 = structureBlockInfo.pos();
            if (boundingBox != null && !boundingBox.isInside((Vec3i)blockPos3)) continue;
            FluidState fluidState = structurePlaceSettings.shouldApplyWaterlogging() ? bulkSectionAccess.getFluidState(blockPos3) : null;
            BlockState blockState = structureBlockInfo.state().mirror(structurePlaceSettings.getMirror()).rotate(structurePlaceSettings.getRotation());
            if (structureBlockInfo.nbt() != null) {
                blockEntity = serverLevelAccessor.getBlockEntity(blockPos3);
                Clearable.tryClear((Object)blockEntity);
                GeneralUtils.SetBlockWithChangeNotified(serverLevelAccessor, bulkSectionAccess, blockPos3, Blocks.BARRIER.defaultBlockState());
            }
            if (!GeneralUtils.SetBlockWithChangeNotified(serverLevelAccessor, bulkSectionAccess, blockPos3, blockState)) continue;
            j = Math.min(j, blockPos3.getX());
            k = Math.min(k, blockPos3.getY());
            l = Math.min(l, blockPos3.getZ());
            m = Math.max(m, blockPos3.getX());
            n = Math.max(n, blockPos3.getY());
            o = Math.max(o, blockPos3.getZ());
            list4.add(Pair.of((Object)blockPos3, (Object)structureBlockInfo.nbt()));
            if (structureBlockInfo.nbt() != null && (blockEntity = serverLevelAccessor.getBlockEntity(blockPos3)) != null) {
                if (blockEntity instanceof RandomizableContainerBlockEntity) {
                    structureBlockInfo.nbt().putLong("LootTableSeed", randomSource.nextLong());
                }
                blockEntity.loadWithComponents(structureBlockInfo.nbt(), (HolderLookup.Provider)serverLevelAccessor.registryAccess());
            }
            if (fluidState == null) continue;
            if (blockState.getFluidState().isSource()) {
                list3.add(blockPos3);
                continue;
            }
            if (!(blockState.getBlock() instanceof LiquidBlockContainer)) continue;
            ((LiquidBlockContainer)blockState.getBlock()).placeLiquid((LevelAccessor)serverLevelAccessor, blockPos3, blockState, fluidState);
            if (fluidState.isSource()) continue;
            list2.add(blockPos3);
        }
        boolean bl = true;
        Direction[] directions = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        while (bl && !list2.isEmpty()) {
            bl = false;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                BlockState blockState2;
                Block block;
                BlockPos blockPos3 = (BlockPos)iterator.next();
                FluidState fluidState2 = bulkSectionAccess.getFluidState(blockPos3);
                for (int p = 0; p < directions.length && !fluidState2.isSource(); ++p) {
                    BlockPos blockPos5 = blockPos3.relative(directions[p]);
                    FluidState fluidState = bulkSectionAccess.getFluidState(blockPos5);
                    if (!fluidState.isSource() || list3.contains(blockPos5)) continue;
                    fluidState2 = fluidState;
                }
                if (!fluidState2.isSource() || !((block = (blockState2 = bulkSectionAccess.getBlockState(blockPos3)).getBlock()) instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)block).placeLiquid((LevelAccessor)serverLevelAccessor, blockPos3, blockState2, fluidState2);
                bl = true;
                iterator.remove();
            }
        }
        if (j <= m) {
            if (!structurePlaceSettings.getKnownShape()) {
                BitSetDiscreteVoxelShape discreteVoxelShape = new BitSetDiscreteVoxelShape(m - j + 1, n - k + 1, o - l + 1);
                for (Pair pair : list4) {
                    BlockPos blockPos6 = (BlockPos)pair.getFirst();
                    discreteVoxelShape.fill(blockPos6.getX() - j, blockPos6.getY() - k, blockPos6.getZ() - l);
                }
                StructureTemplate.updateShapeAtEdge((LevelAccessor)serverLevelAccessor, (int)i, (DiscreteVoxelShape)discreteVoxelShape, (int)j, (int)k, (int)l);
            }
            for (Pair pair : list4) {
                BlockEntity blockEntity;
                BlockPos blockPos7 = (BlockPos)pair.getFirst();
                if (!structurePlaceSettings.getKnownShape()) {
                    BlockState blockState3;
                    BlockState blockState2 = bulkSectionAccess.getBlockState(blockPos7);
                    if (blockState2 != (blockState3 = Block.updateFromNeighbourShapes((BlockState)blockState2, (LevelAccessor)serverLevelAccessor, (BlockPos)blockPos7))) {
                        GeneralUtils.SetBlockWithChangeNotified(serverLevelAccessor, bulkSectionAccess, blockPos7, blockState3);
                    }
                    serverLevelAccessor.blockUpdated(blockPos7, blockState3.getBlock());
                }
                if (pair.getSecond() == null || (blockEntity = serverLevelAccessor.getBlockEntity(blockPos7)) == null) continue;
                blockEntity.setChanged();
            }
        }
        if (!structurePlaceSettings.isIgnoreEntities()) {
            GeneralUtils.placeEntities(serverLevelAccessor, structureTemplate, blockPos, structurePlaceSettings.getMirror(), structurePlaceSettings.getRotation(), structurePlaceSettings.getRotationPivot(), boundingBox, structurePlaceSettings.shouldFinalizeEntities());
        }
    }

    private static boolean SetBlockWithChangeNotified(ServerLevelAccessor serverLevelAccessor, UnsafeBulkSectionAccess bulkSectionAccess, BlockPos blockPos3, BlockState newState) {
        BlockState oldState = bulkSectionAccess.setBlockStateAndGetOldState(blockPos3, newState, false);
        if (oldState != null) {
            serverLevelAccessor.getLevel().onBlockStateChange(blockPos3, oldState, newState);
            return true;
        }
        return false;
    }

    private static void placeEntities(ServerLevelAccessor serverLevelAccessor, StructureTemplate structureTemplate, BlockPos blockPos, Mirror mirror, Rotation rotation, BlockPos blockPos2, @Nullable BoundingBox boundingBox, boolean bl) {
        for (StructureTemplate.StructureEntityInfo structureEntityInfo : ((StructureTemplateAccessor)structureTemplate).bumblezone$getEntityInfoList()) {
            BlockPos blockPos3 = StructureTemplate.transform((BlockPos)structureEntityInfo.blockPos, (Mirror)mirror, (Rotation)rotation, (BlockPos)blockPos2).offset((Vec3i)blockPos);
            if (boundingBox != null && !boundingBox.isInside((Vec3i)blockPos3)) continue;
            CompoundTag compoundTag = structureEntityInfo.nbt.copy();
            Vec3 vec3 = StructureTemplate.transform((Vec3)structureEntityInfo.pos, (Mirror)mirror, (Rotation)rotation, (BlockPos)blockPos2);
            Vec3 vec32 = vec3.add((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
            ListTag listTag = new ListTag();
            listTag.add((Object)DoubleTag.valueOf((double)vec32.x));
            listTag.add((Object)DoubleTag.valueOf((double)vec32.y));
            listTag.add((Object)DoubleTag.valueOf((double)vec32.z));
            compoundTag.put("Pos", (Tag)listTag);
            compoundTag.remove("UUID");
            GeneralUtils.createEntityIgnoreException(serverLevelAccessor, compoundTag).ifPresent(entity -> {
                float f = entity.rotate(rotation);
                entity.moveTo(vec32.x, vec32.y, vec32.z, f + (entity.mirror(mirror) - entity.getYRot()), entity.getXRot());
                if (bl && entity instanceof Mob) {
                    ((Mob)entity).finalizeSpawn(serverLevelAccessor, serverLevelAccessor.getCurrentDifficultyAt(BlockPos.containing((Position)vec32)), MobSpawnType.STRUCTURE, null);
                }
                serverLevelAccessor.addFreshEntityWithPassengers(entity);
            });
        }
    }

    private static Optional<Entity> createEntityIgnoreException(ServerLevelAccessor serverLevelAccessor, CompoundTag compoundTag) {
        try {
            return EntityType.create((CompoundTag)compoundTag, (Level)serverLevelAccessor.getLevel());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static boolean isSimilarInColor(int color1, int color2, int threshold) {
        return Math.abs(GeneralUtils.getRed(color1) - GeneralUtils.getRed(color2)) + Math.abs(GeneralUtils.getGreen(color1) - GeneralUtils.getGreen(color2)) + Math.abs(GeneralUtils.getBlue(color1) - GeneralUtils.getBlue(color2)) < threshold;
    }

    public static boolean isSimilarInVisualColor(int color1, int color2, int hueThreshold, int valueThreshold) {
        double[] hue2;
        double[] hue1 = GeneralUtils.ColorToHsv(color1);
        double hueDiff = hue1[0] - (hue2 = GeneralUtils.ColorToHsv(color2))[0];
        if (hueDiff > 180.0) {
            hueDiff -= 360.0;
        } else if (hueDiff < -180.0) {
            hueDiff += 360.0;
        }
        double hueDistance = Math.sqrt(hueDiff * hueDiff);
        double valueDiff = Math.abs(hue1[2] - hue2[2]);
        return hueDistance < (double)hueThreshold && valueDiff < (double)valueThreshold;
    }

    public static double[] ColorToHsv(int color) {
        int r = GeneralUtils.getRed(color);
        int g = GeneralUtils.getGreen(color);
        int b = GeneralUtils.getBlue(color);
        double h = 0.0;
        double min = Math.min(Math.min(r, g), b);
        double v = Math.max(Math.max(r, g), b);
        double delta = v - min;
        double s = v == 0.0 ? 0.0 : delta / v;
        if (s == 0.0) {
            h = 0.0;
        } else {
            if ((double)r == v) {
                h = (double)(g - b) / delta;
            } else if ((double)g == v) {
                h = 2.0 + (double)(b - r) / delta;
            } else if ((double)b == v) {
                h = 4.0 + (double)(r - g) / delta;
            }
            h *= 60.0;
            if (h < 0.0) {
                h += 360.0;
            }
        }
        double[] hsv = new double[]{h, s * 360.0, v};
        return hsv;
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int colorToInt(int red, int green, int blue) {
        return (red << 16) + (green << 8) + blue;
    }

    public static double capBetween(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    public static List<BlockPos> matchingBlocksOfKindInRange(Level level, BlockPos centerPos, int radius, Predicate<BlockState> predicate) {
        ObjectArrayList validPos = new ObjectArrayList();
        ChunkPos maxChunkPos = new ChunkPos(SectionPos.blockToSectionCoord((int)(centerPos.getX() + radius)), SectionPos.blockToSectionCoord((int)(centerPos.getZ() + radius)));
        ChunkPos minChunkPos = new ChunkPos(SectionPos.blockToSectionCoord((int)(centerPos.getX() - radius)), SectionPos.blockToSectionCoord((int)(centerPos.getZ() - radius)));
        for (int xOffset = minChunkPos.x; xOffset <= maxChunkPos.x; ++xOffset) {
            for (int zOffset = minChunkPos.z; zOffset <= maxChunkPos.z; ++zOffset) {
                LevelChunk chunk = level.getChunk(xOffset, zOffset);
                GeneralUtils.scanChunkForMatchInRange(predicate, (List<BlockPos>)validPos, (ChunkAccess)chunk, centerPos, radius);
            }
        }
        return validPos;
    }

    private static void scanChunkForMatchInRange(Predicate<BlockState> predicate, List<BlockPos> validPos, ChunkAccess chunk, BlockPos originalPos, int radius) {
        BlockPos.MutableBlockPos mutableSectionWorldOrigin = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutableSectionWorldBlockPos = new BlockPos.MutableBlockPos();
        int radiusSq = radius * radius;
        for (int i = chunk.getMinSection(); i < chunk.getMaxSection(); ++i) {
            LevelChunkSection levelChunkSection;
            int sectionWorldY = SectionPos.sectionToBlockCoord((int)i);
            if (sectionWorldY + 15 < originalPos.getY() - radius || sectionWorldY > originalPos.getY() + radius || !(levelChunkSection = chunk.getSection(chunk.getSectionIndexFromSectionY(i))).maybeHas(predicate)) continue;
            mutableSectionWorldOrigin.set(SectionPos.sectionToBlockCoord((int)chunk.getPos().x), sectionWorldY, SectionPos.sectionToBlockCoord((int)chunk.getPos().z));
            for (int yOffset = 0; yOffset < 16; ++yOffset) {
                for (int zOffset = 0; zOffset < 16; ++zOffset) {
                    for (int xOffset = 0; xOffset < 16; ++xOffset) {
                        BlockState blockState;
                        mutableSectionWorldBlockPos.set((Vec3i)mutableSectionWorldOrigin).move(xOffset, yOffset, zOffset);
                        int xDiff = originalPos.getX() - mutableSectionWorldBlockPos.getX();
                        int yDiff = originalPos.getY() - mutableSectionWorldBlockPos.getY();
                        int zDiff = originalPos.getZ() - mutableSectionWorldBlockPos.getZ();
                        if (xDiff * xDiff + yDiff * yDiff + zDiff * zDiff > radiusSq || !predicate.test(blockState = levelChunkSection.getBlockState(xOffset, yOffset, zOffset))) continue;
                        validPos.add(mutableSectionWorldBlockPos.immutable());
                    }
                }
            }
        }
    }

    public static String formatTickDurationNoMilliseconds(int tickDuration, float tickRate) {
        int j = Mth.floor((float)((float)tickDuration / tickRate));
        int k = j / 60;
        return String.format(Locale.ROOT, "%02d:%02d", k %= 60, j %= 60);
    }

    public static int constrainToRange(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public static StructureStart getStructureAt(LevelReader level, StructureManager structureManager, BlockPos blockPos, Structure structure) {
        for (StructureStart structureStart : GeneralUtils.startsForStructure(level, structureManager, SectionPos.of((BlockPos)blockPos), structure)) {
            if (!structureStart.getBoundingBox().isInside((Vec3i)blockPos)) continue;
            return structureStart;
        }
        return StructureStart.INVALID_START;
    }

    public static List<StructureStart> startsForAllStructure(LevelReader level, StructureManager structureManager, SectionPos sectionPos, Predicate<Structure> structureMatch) {
        ChunkAccess chunkAccess = level.getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_REFERENCES);
        Map references = chunkAccess.getAllReferences();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : references.entrySet()) {
            if (!structureMatch.test((Structure)entry.getKey())) continue;
            GeneralUtils.fillStartsForStructure(level, structureManager, (Structure)entry.getKey(), (LongSet)entry.getValue(), arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    public static List<StructureStart> startsForStructure(LevelReader level, StructureManager structureManager, SectionPos sectionPos, Structure structure) {
        ChunkAccess chunkAccess = level.getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_REFERENCES);
        LongSet references = chunkAccess.getReferencesForStructure(structure);
        ImmutableList.Builder builder = ImmutableList.builder();
        GeneralUtils.fillStartsForStructure(level, structureManager, structure, references, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static void fillStartsForStructure(LevelReader level, StructureManager structureManager, Structure structure, LongSet references, Consumer<StructureStart> consumer) {
        LongIterator longIterator = references.iterator();
        while (longIterator.hasNext()) {
            StructureStart structureStart;
            long ref = (Long)longIterator.next();
            SectionPos sectionPos = SectionPos.of((ChunkPos)new ChunkPos(ref), (int)level.getMinSection());
            if (!level.hasChunk(sectionPos.x(), sectionPos.z()) || (structureStart = structureManager.getStartForStructure(sectionPos, structure, (StructureAccess)level.getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_STARTS))) == null || !structureStart.isValid()) continue;
            consumer.accept(structureStart);
        }
    }

    public static List<ItemStack> convertBlockTagsToItemStacks(TagKey<Block> baseTag, @Nullable TagKey<Block> disallowTag) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (Holder blockHolder : BuiltInRegistries.BLOCK.getTagOrEmpty(baseTag)) {
            ItemStack itemStack;
            Item item;
            if (disallowTag != null && blockHolder.is(disallowTag) || (item = ((Block)blockHolder.value()).asItem()) == null || (itemStack = item.getDefaultInstance()).isEmpty()) continue;
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }

    public static List<StructureTemplate.StructureBlockInfo> getShuffledJigsawBlocksWithoutPriority(SinglePoolElement singlePoolElement, StructureTemplateManager structureTemplateManager, BlockPos blockPos, Rotation rotation, RandomSource randomSource) {
        StructureTemplate structureTemplate = (StructureTemplate)((SinglePoolElementAccessor)singlePoolElement).bumblezone$getTemplate().map(arg_0 -> ((StructureTemplateManager)structureTemplateManager).getOrCreate(arg_0), Function.identity());
        ObjectArrayList objectArrayList = structureTemplate.filterBlocks(blockPos, new StructurePlaceSettings().setRotation(rotation), Blocks.JIGSAW, true);
        Util.shuffle((List)objectArrayList, (RandomSource)randomSource);
        return objectArrayList;
    }

    public static boolean isOutsideStructureAllowedBounds(StructurePlaceSettings settings, BlockPos pos) {
        return settings.getBoundingBox() != null && !settings.getBoundingBox().isInside((Vec3i)pos);
    }

    public static boolean isFaceFullFast(BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        BlockState blockstate = blockGetter.getBlockState(blockPos);
        VoxelShape overallShape = blockstate.getCollisionShape(blockGetter, blockPos);
        return GeneralUtils.isFaceFullFast(overallShape, direction);
    }

    public static boolean isFaceFullFast(VoxelShape overallShape, Direction direction) {
        if (overallShape == Shapes.block()) {
            return true;
        }
        if (overallShape == Shapes.empty()) {
            return false;
        }
        return Block.isFaceFull((VoxelShape)overallShape, (Direction)direction);
    }

    public static Optional<Property<Integer>> getBlockCurrentAge(BlockState blockState) {
        Property property;
        Optional<Property<Integer>> propertyOptional = blockState.getProperties().stream().filter(p -> p.getName().equalsIgnoreCase("age")).findAny();
        if (propertyOptional.isPresent() && (property = propertyOptional.get()).getValueClass() == Integer.class) {
            return propertyOptional;
        }
        return Optional.empty();
    }

    public static Optional<Integer> getAgePropertyMaxAge(Property<Integer> ageProperty) {
        return ageProperty.getPossibleValues().stream().max(Comparable::compareTo);
    }

    @NotNull
    public static BlockState copyNonAgeProperties(BlockState oldState, BlockState newState) {
        for (Property property : newState.getProperties()) {
            if (property.getName().equalsIgnoreCase("age")) continue;
            newState = GeneralUtils.copyProperty(oldState, newState, property);
        }
        return newState;
    }

    @NotNull
    private static <T extends Comparable<T>> BlockState copyProperty(BlockState state, BlockState newState, Property<T> propertyToCopy) {
        if (newState.hasProperty(propertyToCopy) && state.hasProperty(propertyToCopy)) {
            newState = (BlockState)newState.setValue(propertyToCopy, state.getValue(propertyToCopy));
        }
        return newState;
    }

    public static final class Lazy<T> {
        private volatile T value;
        private Supplier<T> supplierValue;

        public Lazy() {
        }

        public Lazy(Supplier<T> supplierValue) {
            this.supplierValue = supplierValue;
        }

        public T getOrCompute(Supplier<T> supplier) {
            T result = this.value;
            return result == null ? this.maybeCompute(supplier) : result;
        }

        private synchronized T maybeCompute(Supplier<T> supplier) {
            if (this.value == null) {
                this.value = Objects.requireNonNull(supplier.get());
            }
            return this.value;
        }

        public T getOrFillFromInternal() {
            T result = this.value;
            return result == null ? this.maybeCompute(this.supplierValue) : result;
        }
    }
}

