/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.mixin.enchantments;

import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import com.telepathicgrunt.the_bumblezone.services.PlatformService;
import com.telepathicgrunt.the_bumblezone.utils.TriState;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Enchantment.class})
public class EnchantmentMixin {
    @Inject(method={"canEnchant(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void bumblezone$customAllowDisallowEnchantments1(ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        this.bumblezone$checkEnchantability(itemStack, cir);
    }

    @Inject(method={"isPrimaryItem(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void bumblezone$customAllowDisallowEnchantments2(ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        this.bumblezone$checkEnchantability(itemStack, cir);
    }

    @Inject(method={"isSupportedItem(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void bumblezone$customAllowDisallowEnchantments3(ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        this.bumblezone$checkEnchantability(itemStack, cir);
    }

    @Unique
    private void bumblezone$checkEnchantability(ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        Item item = itemStack.getItem();
        if (item instanceof ItemExtension) {
            ItemExtension itemExtension = (ItemExtension)item;
            PlatformService.INSTANCE.getCurrentRegistryAccess().registry(Registries.ENCHANTMENT).ifPresent(enchantmentRegistry -> enchantmentRegistry.getResourceKey((Object)((Enchantment)this)).ifPresent(resourceKey -> {
                TriState result = itemExtension.bz$canEnchant(itemStack, (Holder<Enchantment>)enchantmentRegistry.getHolderOrThrow(resourceKey));
                if (result != TriState.PASS) {
                    cir.setReturnValue((Object)(result == TriState.ALLOW ? 1 : 0));
                }
            }));
        }
    }
}

