/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.dispenserbehavior;

import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.DefaultDispenseItemBehaviorInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.services.PlatformService;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HoneyBottleDispenseBehavior
extends DefaultDispenseItemBehavior {
    public static DispenseItemBehavior DEFAULT_HONEY_BOTTLE_DISPENSE_BEHAVIOR;
    public static final DefaultDispenseItemBehavior DROP_ITEM_BEHAVIOR;

    public ItemStack execute(BlockSource source, ItemStack stack) {
        Position dispensePosition;
        BlockPos dispenseBlockPos;
        ServerLevel world = source.level();
        BlockState blockstate = world.getBlockState(dispenseBlockPos = BlockPos.containing((Position)(dispensePosition = DispenserBlock.getDispensePosition((BlockSource)source))));
        if (blockstate.is((Block)BzBlocks.HONEYCOMB_BROOD.get()) && stack.is(BzTags.BEE_FEEDING_ITEMS)) {
            boolean deniedBeeSpawn = false;
            int stage = (Integer)blockstate.getValue((Property)HoneycombBrood.STAGE);
            if (stage == 3) {
                BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos().set((Vec3i)dispenseBlockPos);
                blockpos.move(((Direction)blockstate.getValue((Property)HoneycombBrood.FACING)).getOpposite());
                if (!world.getBlockState((BlockPos)blockpos).isSolid()) {
                    Mob beeEntity = (Mob)EntityType.BEE.create((Level)world);
                    beeEntity.moveTo((double)((float)blockpos.getX() + 0.5f), (double)blockpos.getY(), (double)((float)blockpos.getZ() + 0.5f), beeEntity.getRandom().nextFloat() * 360.0f, 0.0f);
                    beeEntity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(BlockPos.containing((Position)beeEntity.position())), MobSpawnType.TRIGGERED, null);
                    beeEntity.setBaby(true);
                    PlatformService.INSTANCE.finalizeSpawn(beeEntity, (ServerLevelAccessor)world, null, MobSpawnType.DISPENSER);
                    deniedBeeSpawn = !world.addFreshEntity((Entity)beeEntity);
                    world.setBlockAndUpdate(dispenseBlockPos, (BlockState)blockstate.setValue((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(0)));
                }
            } else {
                world.setBlockAndUpdate(dispenseBlockPos, (BlockState)blockstate.setValue((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(stage + 1)));
            }
            if (!deniedBeeSpawn) {
                stack.shrink(1);
            }
            if (!deniedBeeSpawn && !BzGeneralConfigs.dispensersDropGlassBottles) {
                if (!stack.isEmpty()) {
                    HoneyBottleDispenseBehavior.addGlassBottleToDispenser(source);
                } else {
                    stack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                }
            } else {
                DROP_ITEM_BEHAVIOR.dispense(source, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
        } else if (blockstate.getBlock() == BzBlocks.POROUS_HONEYCOMB.get()) {
            world.setBlockAndUpdate(dispenseBlockPos, ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).defaultBlockState());
            stack.shrink(1);
            if (!BzGeneralConfigs.dispensersDropGlassBottles) {
                if (!stack.isEmpty()) {
                    HoneyBottleDispenseBehavior.addGlassBottleToDispenser(source);
                } else {
                    stack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                }
            }
        } else {
            if (DEFAULT_HONEY_BOTTLE_DISPENSE_BEHAVIOR instanceof DefaultDispenseItemBehavior) {
                return ((DefaultDispenseItemBehaviorInvoker)DEFAULT_HONEY_BOTTLE_DISPENSE_BEHAVIOR).bumblezone$invokeExecute(source, stack);
            }
            return DEFAULT_HONEY_BOTTLE_DISPENSE_BEHAVIOR.dispense(source, stack);
        }
        return stack;
    }

    protected void playSound(BlockSource source) {
        source.level().levelEvent(1002, source.pos(), 0);
    }

    private static void addGlassBottleToDispenser(BlockSource source) {
        ItemStack bottle;
        DispenserBlockEntity dispenser;
        if (source.blockEntity() instanceof DispenserBlockEntity && !HopperBlockEntity.addItem(null, (Container)(dispenser = source.blockEntity()), (ItemStack)(bottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE)), null).isEmpty()) {
            DROP_ITEM_BEHAVIOR.dispense(source, bottle);
        }
    }

    static {
        DROP_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior();
    }
}

