/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import com.telepathicgrunt.the_bumblezone.utils.TriState;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BeeCannon
extends Item
implements ItemExtension {
    public static final String TAG_BEES = "BeesStored";
    public static final int MAX_NUMBER_OF_BEES = 3;

    public BeeCannon(Item.Properties properties) {
        super(properties.component((DataComponentType)BzDataComponents.BEE_CANNON_DATA.get(), (Object)CustomData.EMPTY));
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (itemStack.get((DataComponentType)BzDataComponents.BEE_CANNON_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.BEE_CANNON_DATA.get(), (Object)CustomData.EMPTY);
        }
    }

    public void releaseUsing(ItemStack beeCannon, Level level, LivingEntity livingEntity, int currentDuration) {
        if (!level.isClientSide() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack mutableBeeCannon = player.getItemInHand(InteractionHand.MAIN_HAND);
            int numberOfBees = BeeCannon.getNumberOfBees(mutableBeeCannon);
            int remainingDuration = this.getUseDuration(mutableBeeCannon, livingEntity) - currentDuration;
            if ((float)remainingDuration / (float)this.getChargeDuration(mutableBeeCannon, livingEntity) > 0.99f && numberOfBees > 0) {
                List<Entity> bees = BeeCannon.tryReleaseBees(level, mutableBeeCannon);
                if (bees.isEmpty()) {
                    return;
                }
                player.awardStat(Stats.ITEM_USED.get((Object)beeCannon.getItem()));
                float maxDistance = 15.0f;
                Vec3 playerEyePos = new Vec3(player.getX(), player.getEyeY() - 0.25, player.getZ());
                Vec3 maxDistanceDirection = player.getLookAngle().multiply((double)maxDistance, (double)maxDistance, (double)maxDistance);
                Vec3 finalPos = playerEyePos.add(maxDistanceDirection);
                BlockHitResult hitResult = level.clip(new ClipContext(playerEyePos, finalPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                if (hitResult.getType() != HitResult.Type.MISS) {
                    finalPos = hitResult.getLocation();
                }
                EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Level)level, (Entity)player, (Vec3)playerEyePos, (Vec3)finalPos, (AABB)player.getBoundingBox().expandTowards(maxDistanceDirection), entity -> !entity.isInvisibleTo(player), (float)1.0f);
                bees.forEach(bee -> {
                    bee.moveTo(playerEyePos.x(), playerEyePos.y() - 0.5, playerEyePos.z(), player.getYRot(), player.getXRot());
                    bee.setDeltaMovement(player.getLookAngle().multiply(2.5, 2.5, 2.5));
                    level.addFreshEntity(bee);
                    if (bee instanceof NeutralMob) {
                        LivingEntity targetEntity;
                        Entity patt0$temp;
                        NeutralMob neutralMob = (NeutralMob)bee;
                        if (entityHitResult != null && entityHitResult.getType() != HitResult.Type.MISS && (patt0$temp = entityHitResult.getEntity()) instanceof LivingEntity && !((targetEntity = (LivingEntity)patt0$temp) instanceof Bee)) {
                            neutralMob.setRemainingPersistentAngerTime(60);
                            neutralMob.setPersistentAngerTarget(targetEntity.getUUID());
                            if (bee instanceof Bee) {
                                Bee trueBee = (Bee)bee;
                                trueBee.setTarget(targetEntity);
                            }
                        }
                    }
                    mutableBeeCannon.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                });
                level.playSound(null, player.blockPosition(), (SoundEvent)BzSounds.BEE_CANNON_FIRES.get(), SoundSource.PLAYERS, 1.0f, player.getRandom().nextFloat() * 0.2f + 0.6f);
                if (numberOfBees >= 3 && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((GenericTrigger)((Object)BzCriterias.BEE_CANNON_FULL_TRIGGER.get())).trigger(serverPlayer);
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack beeCannon = player.getItemInHand(interactionHand);
        if (BeeCannon.getNumberOfBees(beeCannon) == 0) {
            return InteractionResultHolder.fail((Object)beeCannon);
        }
        player.startUsingItem(interactionHand);
        return InteractionResultHolder.consume((Object)beeCannon);
    }

    public InteractionResult interactLivingEntity(ItemStack beeCannon, Player playerEntity, LivingEntity entity, InteractionHand playerHand) {
        Bee bee;
        if (playerEntity.level().isClientSide() || !(entity instanceof Bee) || (bee = (Bee)entity).isAngry() || bee.getType().is(BzTags.CANNON_BEES_DISALLOWED_BEE) || playerEntity.getCooldowns().isOnCooldown(beeCannon.getItem())) {
            return InteractionResult.PASS;
        }
        ItemStack mutableBeeCannon = playerEntity.getItemInHand(playerHand);
        boolean addedBee = BeeCannon.tryAddBee(mutableBeeCannon, (Entity)entity);
        if (addedBee) {
            playerEntity.swing(playerHand, true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static List<Entity> tryReleaseBees(Level level, ItemStack beeCannonItem) {
        if (BeeCannon.getNumberOfBees(beeCannonItem) > 0 && beeCannonItem.has((DataComponentType)BzDataComponents.BEE_CANNON_DATA.get())) {
            CompoundTag cannonTag = ((CustomData)beeCannonItem.get((DataComponentType)BzDataComponents.BEE_CANNON_DATA.get())).copyTag();
            ListTag beeList = cannonTag.getList(TAG_BEES, 10);
            ObjectArrayList releasedBees = new ObjectArrayList();
            for (int i = beeList.size() - 1; i >= 0; --i) {
                CompoundTag beeTag = beeList.getCompound(0);
                beeList.remove(0);
                releasedBees.add(EntityType.loadEntityRecursive((CompoundTag)beeTag, (Level)level, entityx -> entityx));
            }
            beeCannonItem.set((DataComponentType)BzDataComponents.BEE_CANNON_DATA.get(), (Object)CustomData.of((CompoundTag)cannonTag));
            return releasedBees;
        }
        return new ObjectArrayList();
    }

    public static boolean tryAddBee(ItemStack beeCannonItem, Entity bee) {
        if (BeeCannon.getNumberOfBees(beeCannonItem) < 3 && beeCannonItem.has((DataComponentType)BzDataComponents.BEE_CANNON_DATA.get())) {
            String beeTypeRL = bee.getEncodeId();
            if (beeTypeRL == null) {
                return false;
            }
            CompoundTag cannonTag = ((CustomData)beeCannonItem.get((DataComponentType)BzDataComponents.BEE_CANNON_DATA.get())).copyTag();
            ListTag beeList = cannonTag.getList(TAG_BEES, 10);
            CompoundTag beeTag = new CompoundTag();
            bee.stopRiding();
            bee.ejectPassengers();
            beeTag.putString("id", beeTypeRL);
            bee.saveWithoutId(beeTag);
            UUID uUID = bee.getUUID();
            bee.load(beeTag);
            bee.setUUID(uUID);
            beeTag.remove("UUID");
            beeList.add((Object)beeTag);
            cannonTag.put(TAG_BEES, (Tag)beeList);
            bee.discard();
            beeCannonItem.set((DataComponentType)BzDataComponents.BEE_CANNON_DATA.get(), (Object)CustomData.of((CompoundTag)cannonTag));
            return true;
        }
        return false;
    }

    public static int getNumberOfBees(ItemStack beeCannonItem) {
        if (beeCannonItem.has((DataComponentType)BzDataComponents.BEE_CANNON_DATA.get())) {
            CompoundTag cannonTag = ((CustomData)beeCannonItem.get((DataComponentType)BzDataComponents.BEE_CANNON_DATA.get())).copyTag();
            if (cannonTag.contains(TAG_BEES)) {
                ListTag beeList = cannonTag.getList(TAG_BEES, 10);
                return beeList.size();
            }
            ListTag listTag = new ListTag();
            cannonTag.put(TAG_BEES, (Tag)listTag);
        }
        return 0;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is(BzTags.BEE_CANNON_REPAIR_ITEMS);
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public int getChargeDuration(ItemStack itemStack, LivingEntity livingEntity) {
        float chargeTime = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)itemStack, (LivingEntity)livingEntity, (float)1.25f);
        return Mth.floor((float)(chargeTime * 20.0f));
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    @Override
    public TriState bz$canEnchant(ItemStack itemstack, Holder<Enchantment> enchantment) {
        return enchantment.is(BzTags.ENCHANTABLES_BEE_CANNON_FORCED_ALLOWED) ? TriState.ALLOW : TriState.PASS;
    }
}

